--
-- PostgreSQL database dump
--

-- Started on 2008-12-13 17:22:41

DROP PROCEDURAL LANGUAGE IF EXISTS plpgsql; 
CREATE PROCEDURAL LANGUAGE plpgsql;

--
-- TOC entry 1275 (class 1259 OID 222053)
-- Dependencies: 1612 4
-- Name: global_parameters; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE global_parameters (
    global_parameters_id bigint DEFAULT nextval(('public.hibernate_sequence'::text)::regclass) NOT NULL,
    parameter_name character varying(255) NOT NULL,
    parameter_value character varying(255) NOT NULL
);


ALTER TABLE public.global_parameters OWNER TO shipment_simulator_user;

--
-- TOC entry 1281 (class 1259 OID 222110)
-- Dependencies: 4
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: shipment_simulator_user
--

CREATE SEQUENCE hibernate_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO shipment_simulator_user;

--
-- TOC entry 1276 (class 1259 OID 222065)
-- Dependencies: 4
-- Name: item_shipping; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE item_shipping (
    item_shipping_id bigint NOT NULL,
    product_code character varying(255),
    left_quantity integer,
    order_shipping_id bigint
);


ALTER TABLE public.item_shipping OWNER TO shipment_simulator_user;

--
-- TOC entry 1277 (class 1259 OID 222069)
-- Dependencies: 4
-- Name: order_shipping; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE order_shipping (
    order_shipping_id bigint NOT NULL,
    order_number character varying(255),
    customer_number character varying(255),
    next_processing_date timestamp without time zone,
    shipping_state_id bigint
);


ALTER TABLE public.order_shipping OWNER TO shipment_simulator_user;

--
-- TOC entry 1278 (class 1259 OID 222078)
-- Dependencies: 4
-- Name: shipment; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE shipment (
    shipment_id bigint NOT NULL,
    tracking_code character varying(255),
    dispatch_date timestamp without time zone,
    order_shipping_id bigint
);


ALTER TABLE public.shipment OWNER TO shipment_simulator_user;

--
-- TOC entry 1279 (class 1259 OID 222082)
-- Dependencies: 4
-- Name: shipment_item; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE shipment_item (
    shipment_item_id bigint NOT NULL,
    shipped_product_code character varying(255),
    shipped_quantity integer,
    shipment_id bigint
);


ALTER TABLE public.shipment_item OWNER TO shipment_simulator_user;

--
-- TOC entry 1280 (class 1259 OID 222086)
-- Dependencies: 4
-- Name: shipping_state; Type: TABLE; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

CREATE TABLE shipping_state (
    shipping_state_id bigint NOT NULL,
    state_name character varying(255)
);


ALTER TABLE public.shipping_state OWNER TO shipment_simulator_user;

--
-- TOC entry 1614 (class 2606 OID 222057)
-- Dependencies: 1275 1275
-- Name: global_parameters_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY global_parameters
    ADD CONSTRAINT global_parameters_pkey PRIMARY KEY (global_parameters_id);


--
-- TOC entry 1616 (class 2606 OID 222068)
-- Dependencies: 1276 1276
-- Name: item_shipping_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY item_shipping
    ADD CONSTRAINT item_shipping_pkey PRIMARY KEY (item_shipping_id);


--
-- TOC entry 1618 (class 2606 OID 222077)
-- Dependencies: 1277 1277
-- Name: order_shipping_order_number_key; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY order_shipping
    ADD CONSTRAINT order_shipping_order_number_key UNIQUE (order_number);


--
-- TOC entry 1620 (class 2606 OID 222075)
-- Dependencies: 1277 1277
-- Name: order_shipping_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY order_shipping
    ADD CONSTRAINT order_shipping_pkey PRIMARY KEY (order_shipping_id);


--
-- TOC entry 1624 (class 2606 OID 222085)
-- Dependencies: 1279 1279
-- Name: shipment_item_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY shipment_item
    ADD CONSTRAINT shipment_item_pkey PRIMARY KEY (shipment_item_id);


--
-- TOC entry 1622 (class 2606 OID 222081)
-- Dependencies: 1278 1278
-- Name: shipment_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY shipment
    ADD CONSTRAINT shipment_pkey PRIMARY KEY (shipment_id);


--
-- TOC entry 1626 (class 2606 OID 222089)
-- Dependencies: 1280 1280
-- Name: shipping_state_pkey; Type: CONSTRAINT; Schema: public; Owner: shipment_simulator_user; Tablespace: 
--

ALTER TABLE ONLY shipping_state
    ADD CONSTRAINT shipping_state_pkey PRIMARY KEY (shipping_state_id);


--
-- TOC entry 1628 (class 2606 OID 222095)
-- Dependencies: 1625 1277 1280
-- Name: fk9476df7ffc58b314; Type: FK CONSTRAINT; Schema: public; Owner: shipment_simulator_user
--

ALTER TABLE ONLY order_shipping
    ADD CONSTRAINT fk9476df7ffc58b314 FOREIGN KEY (shipping_state_id) REFERENCES shipping_state(shipping_state_id);


--
-- TOC entry 1630 (class 2606 OID 222105)
-- Dependencies: 1279 1278 1621
-- Name: fkda3bb2986e9b2083; Type: FK CONSTRAINT; Schema: public; Owner: shipment_simulator_user
--

ALTER TABLE ONLY shipment_item
    ADD CONSTRAINT fkda3bb2986e9b2083 FOREIGN KEY (shipment_id) REFERENCES shipment(shipment_id);


--
-- TOC entry 1629 (class 2606 OID 222100)
-- Dependencies: 1278 1277 1619
-- Name: fke139719a7b3bf98e; Type: FK CONSTRAINT; Schema: public; Owner: shipment_simulator_user
--

ALTER TABLE ONLY shipment
    ADD CONSTRAINT fke139719a7b3bf98e FOREIGN KEY (order_shipping_id) REFERENCES order_shipping(order_shipping_id);


--
-- TOC entry 1627 (class 2606 OID 222090)
-- Dependencies: 1277 1276 1619
-- Name: fkf85c595a7b3bf98e; Type: FK CONSTRAINT; Schema: public; Owner: shipment_simulator_user
--

ALTER TABLE ONLY item_shipping
    ADD CONSTRAINT fkf85c595a7b3bf98e FOREIGN KEY (order_shipping_id) REFERENCES order_shipping(order_shipping_id);


--
-- TOC entry 1635 (class 0 OID 0)
-- Dependencies: 4
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2008-12-13 17:22:41

--
-- PostgreSQL database dump complete
--

