/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.ws;

import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

import org.springframework.ws.wsdl.wsdl11.provider.DefaultMessagesProvider;


/**
 * Customized version of the <code>DefaultMessageProvider</code> generating always 
 * '<code>parameters</code>' as the part name. Required as a hack for the MS WebService Task 
 * which works properly only with this part name.
 * 
 * 
 * @author Wladimir Safonov
 *
 */
public class CustomPartNameMessagesProvider extends DefaultMessagesProvider {

    @Override
    protected void populatePart(Definition definition, Part part, QName elementName) throws WSDLException {
        part.setElementName(elementName);
        part.setName("parameters");
    }
    
}
