/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.jsf.beans;

import java.util.Date;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount;

/**
 * @author Claudius Haecker
 * This is the Backing Bean for Volume Discounts. (One instance for each row in the Volume Discounts table.)
 * Firstly it is a wrapper for VolumeDiscount items because JSF needs String-properties while the domain objects use numbers,
 * secondly it tracks which volume discounts have been changed (for an update of the database) and which are marked for deletion
 * since the last synchronization with the database.
 */
public class VolumeDiscountDelegate {

    private VolumeDiscount volumeDiscount;
    private boolean markedForDeletion = false;

    // this VolumeDiscount instance has been modified by the user
    // and the changes have not been written to the database.
    private boolean modifiedByGui = false;

    /**
     * @param volumeDiscount the volumeDiscount that is wrapped by this object
     */
    public VolumeDiscountDelegate(VolumeDiscount volumeDiscount) {
        this.volumeDiscount = volumeDiscount;
    }

    /**
     * If the fromQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @return the fromQuantity
     */
    public String getFromQuantityInGui() {
        Integer fromQuantity = volumeDiscount.getFromQuantity();
        return fromQuantity == null ? "" : fromQuantity.toString();
    }

    /** 
     * If the fromQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @param fromQuantity the fromQuantity to set
     */
    public void setFromQuantityInGui(String fromQuantity) {
        Integer from = (fromQuantity == null || fromQuantity.equals("")) ? null : Integer.decode(fromQuantity);
        if ((from == null && getFromQuantity() != null) || (from != null && !from.equals(getFromQuantity()))) {
            modifiedByGui = true;
            volumeDiscount.setFromQuantity(from);
        }
    }

    /**
     * If the toQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @return the toQuantity
     */

    public String getToQuantityInGui() {
        Integer toQuantity = volumeDiscount.getToQuantity();
        return toQuantity == null ? "" : toQuantity.toString();
    }

    /**
     * If the toQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @param toQuantity the toQuantity to set
     */
    public void setToQuantityInGui(String toQuantity) {
        Integer to = (toQuantity == null || toQuantity.equals("")) ? null : Integer.decode(toQuantity);
        if ((to == null && getToQuantity() != null) || (to != null && !to.equals(getToQuantity()))) {
            modifiedByGui = true;
            volumeDiscount.setToQuantity(to);
        }
    }

    /**
     * If the percentage is Float.NaN, then an empty String is displayed in the Frontend.
     * @return the percentage
     */

    public String getPercentageInGui() {
        float percentage = volumeDiscount.getPercentage();
        return Float.isNaN(percentage) ? "" : Float.toString(percentage);
    }

    /**
     * If the percentage is Float.NaN, then an empty String is displayed in the Frontend.
     * @param percentage the percentage to set
     */
    public void setPercentageInGui(String percentage) {
        float percentageFloat = (percentage == null || percentage.equals("")) ? Float.NaN : Float
                .parseFloat(percentage);
        if (Float.isNaN(percentageFloat) ? !Float.isNaN(getPercentage()) : (percentageFloat != getPercentage())) {
            modifiedByGui = true;
            volumeDiscount.setPercentage(percentageFloat);
        }
    }

    /**
     * @return markedForDeletion
     */
    public String getMarkedForDeletionByGui() {
        return markedForDeletion ? "true" : "false";
    }

    /**
     * @param markedForDeletion the markedForDeletion to set
     */
    public void setMarkedForDeletionByGui(String markedForDeletion) {
        this.markedForDeletion = markedForDeletion.toLowerCase().matches("\\s*(true|on|yes)\\s*");
    }

    /**
     * @return modifiedByGui
     */
    public boolean isModifiedByGui() {
        return modifiedByGui;
    }

    /**
     * @param modifiedByGui the modifiedByGui to set
     */
    public void setModifiedByGui(boolean modifiedByGui) {
        this.modifiedByGui = modifiedByGui;
    }

    /**
     * @return the dateCreated
     */

    public Date getDateCreated() {
        return volumeDiscount.getDateCreated();
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        volumeDiscount.setDateCreated(dateCreated);

    }

    /**
     * @return the lastModified
     */

    public Date getDateLastModified() {
        return volumeDiscount.getDateLastModified();
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        volumeDiscount.setDateLastModified(dateLastModified);

    }

    /**
     * If the fromQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @return the fromQuantity
     */
    public Integer getFromQuantity() {
        return volumeDiscount.getFromQuantity();
    }

    /**
     * If the fromQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @param fromQuantity the fromQuantity to set
     */
    public void setFromQuantity(Integer fromQuantity) {
        volumeDiscount.setFromQuantity(fromQuantity);
    }

    /**
     * If the toQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @return the toQuantity
     */

    public Integer getToQuantity() {
        return volumeDiscount.getToQuantity();
    }

    /**
     * If the toQuantity is <code>null</code>, then an empty String is displayed in the Frontend.
     * @param toQuantity the toQuantity to set
     */
    public void setToQuantity(Integer toQuantity) {
        volumeDiscount.setToQuantity(toQuantity);

    }

    /**
    * If the percentage is Float.NaN, then an empty String is displayed in the Frontend.
     * @return the percentage
     */
    public float getPercentage() {
        return volumeDiscount.getPercentage();
    }

    /**
     * If the percentage is Float.NaN, then an empty String is displayed in the Frontend.
     * @param percentage the percentage to set
     */
    public void setPercentage(float percentage) {
        volumeDiscount.setPercentage(percentage);

    }

    /**
     * @return the markedForDeletion
     */
    public boolean isMarkedForDeletion() {
        return markedForDeletion;
    }

    /**
     * @param markedForDeletion the markedForDeletion to set
     */
    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    /**
     * @return the volumeDiscount that is wrapped by this object
     */
    public VolumeDiscount getVolumeDiscount() {
        return volumeDiscount;
    }

    /**
     * @param volumeDiscount the volumeDiscount that is wrapped by this object
     */
    public void setVolumeDiscount(VolumeDiscount volumeDiscount) {
        this.volumeDiscount = volumeDiscount;
    }
}
