/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.tests.be.service;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingManager;
import de.itemis.qimpress.showcase.pricing_simulator.be.service.ServiceLocator;

/**
 * Integration test for 
 * {@link de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingManagerImpl} 
 * service interface. Includes only writing methods.
 * 
 * @author Wladimir Safonov
 *
 */
public class PricingManagerWriteAccessTest {

    private static final Logger LOG = Logger.getLogger(PricingManagerWriteAccessTest.class);
    
    private static PricingManager pricingManager = ServiceLocator.getInstance().getPricingManager();
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initTestSuite()");
        }
        
        try {
        } catch (Exception e) {
            e.printStackTrace();
            fail("Failed to locate PricingManager");
        }
        assertNotNull("PricingManager not found", pricingManager);
    }
    
    @Test
    @Ignore
    public void testSaveVolumeDiscountList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("testSaveVolumeDiscountList()");
        }
        
        List<VolumeDiscount> listToSaveOrUpdate = new LinkedList<VolumeDiscount>();
        
        VolumeDiscount vd = new VolumeDiscount();
        vd.setFromQuantity(11);
        vd.setToQuantity(15);
        vd.setPercentage(7.7f);
        listToSaveOrUpdate.add(vd);
        
        try {
            pricingManager.saveVolumeDiscountList(listToSaveOrUpdate);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to save new VolumeDiscount");
        }
        assertNotNull("Failed to get generated Id of the saved VolumeDiscount", vd.getId());
        
    }
    
    @Test
    @Ignore
    public void testDeleteVolumeDiscountList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("testDeleteVolumeDiscountList()");
        }
        
        List<VolumeDiscount> listToDelete = new LinkedList<VolumeDiscount>();

        VolumeDiscount vd = new VolumeDiscount(3L);
        listToDelete.add(vd);
        
        try {
            pricingManager.deleteVolumeDiscountList(listToDelete);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to delete VolumeDiscount");
        }
    }
}
