/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.tests.be.service;

import java.util.List;

import javax.naming.NamingException;

import org.junit.BeforeClass;
import org.junit.Test;

import static org.junit.Assert.*;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingCsvManager;
import de.itemis.qimpress.showcase.pricing_simulator.be.service.ServiceLocator;

/**
 * Integration test for 
 * {@link de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingCsvManagerImpl} 
 * service interface.
 * 
 * @author Wladimir Safonov
 * @author Claudius Haecker
 */
public class CsvPricingManagerTest {

    private static PricingCsvManager CSV_PRICING_MANAGER = ServiceLocator.getInstance().getPricingCsvManager();
    
    /**
     * inits variables, especially CSV_PRICING_MANAGER
     */
    @BeforeClass
    public static void initTestSuite() {
        
        assertNotNull("PricingCsvManager not found", CSV_PRICING_MANAGER);
    }
    
    /**
     * asserts that the number of all product prices is correct
     */
    @Test
    public void testGetAllProductCountryPrices() {
        List<ProductPrice> allProductCountryPrices = null;
        try {
            allProductCountryPrices = CSV_PRICING_MANAGER.getAllProductCountryPrices();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load all ProductPrices");
        }
        assertNotNull("Failed to load all ProductPrices: result list is null", allProductCountryPrices);
        assertTrue("Wrong result list size for all ProductPrices", allProductCountryPrices.size() == 408);
    }
}
