/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.service;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Service instance locator for the {@link de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingManager}.
 * 
 * @author Wladimir Safonov
 *
 */
public final class ServiceLocator {
    
    // ServiceLocator logger
    private static final Logger LOG = Logger.getLogger(ServiceLocator.class);
    
    // ServiceLocator singleton instance
    private static ServiceLocator SERVICE_LOCATOR_INSTANCE;
    
    // Spring application context with PricingManager service instance
    private ApplicationContext appContext;
    
    /**
     * Instantiates application context
     */
    private ServiceLocator() {
        LOG.info("Creating ApplicationContext");
        appContext = new ClassPathXmlApplicationContext("applicationContext.xml");
    }

    /**
     * Gets the singleton instance of the this ServiceLocator
     * 
     * @return ServiceLocator singleton instance
     */
    public static ServiceLocator getInstance() {
        if (SERVICE_LOCATOR_INSTANCE == null) {
            SERVICE_LOCATOR_INSTANCE = new ServiceLocator();
        }
        return SERVICE_LOCATOR_INSTANCE;
    }
    
    private Object getService(String serviceObjectName) throws NamingException {
        Object serviceObj = appContext.getBean(serviceObjectName);
        if (serviceObj == null) {
            String errMsg = "Service object '" + serviceObjectName + "' not found in the context";
            LOG.error(errMsg);
            throw new NamingException(errMsg);
        }
        return serviceObj;
    }
    
    public PricingManager getPricingManager() {
                try {
            return (PricingManager) getService("pricingManager");
        } catch (NamingException e) {
            e.printStackTrace();
            throw new Error("Could not get service pricingManager", e);
        }
    }
    
    public PricingCsvManager getPricingCsvManager() {
                try {
            return (PricingCsvManager) getService("pricingCsvManager");
        } catch (NamingException e) {
            e.printStackTrace();
            throw new Error("Could not get service pricingCsvManager", e);
        }
    }

}
