/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.service;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.pricing_simulator.be.dao.ProductPriceDao;
import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;

/**
 * @author Wladimir Safonov
 *
 */
public class PricingCsvManagerImpl implements PricingCsvManager {

    private static final Logger LOG = Logger.getLogger(PricingCsvManagerImpl.class);

    private ProductPriceDao productPriceDao;

    /**
     * @param productPriceDao the productPriceDao to set
     */
    public void setProductPriceDao(ProductPriceDao productPriceDao) {
        this.productPriceDao = productPriceDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.service.PricingCsvManager#getAllProductCountryPrices()
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<ProductPrice> getAllProductCountryPrices() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllProductCountryPrices()");
        }

        List<ProductPrice> allCountryPrices = null;
        try {
            allCountryPrices = productPriceDao.getAllCountryPrices();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        return allCountryPrices;
    }

}
