/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.service;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.ApplicationException;

/**
 * CSV export service interface for the Pricing engine. 
 * Includes service methods relevant for CSV export processing.
 * 
 * @author Wladimir Safonov
 *
 */
public interface PricingCsvManager {

    /**
     * Loads a list of all stored country-specific prices for all products. 
     * Product standard prices are not included.
     * 
     * @return list of all country-specific prices for all products
     * @throws ApplicationException if an error occured that cannot be resolved in the business layer
     */
    public List<ProductPrice> getAllProductCountryPrices() throws ApplicationException;
}
