/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * Each object of this class holds a category customers can be ranked in.
* @author Claudius Haecker
 *
 */
@Entity
@Table(name = "customer_category")
public class CustomerCategory implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -6782186938078424230L;
    private Date dateCreated;
    private Date dateLastModified;
    private String customerCategoryName;
    private String customerCategoryKey;
    private String customerCategoryId;

    public CustomerCategory(String customerCategoryId, String customerCategoryName, String customerCategoryKey,
            Date dateCreated, Date lastModified) {
        this.dateCreated = dateCreated;
        this.dateLastModified = lastModified;
        this.customerCategoryName = customerCategoryName;
        this.customerCategoryKey = customerCategoryKey;
        this.customerCategoryId = customerCategoryId;
    }

    public CustomerCategory() {
    }

    /**
* returns the date set by the database on each row when <code>this</code> was inserted into the database.
* @return the creation date
*/
@Column(name = "date_created", nullable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    public void setDateLastModified(Date lastModified) {
        this.dateLastModified = lastModified;
    }

    @Column(name = "customer_category_name")
    public String getCustomerCategoryName() {
        return customerCategoryName;
    }

    public void setCustomerCategoryName(String customerCategoryName) {
        this.customerCategoryName = customerCategoryName;
    }

    @Column(name = "customer_category_key")
    public String getCustomerCategoryKey() {
        return customerCategoryKey;
    }

    public void setCustomerCategoryKey(String customerCategoryKey) {
        this.customerCategoryKey = customerCategoryKey;
    }

    @Id
    @OneToMany(mappedBy = "customer")
    @JoinColumn(name = "customer_type_id")
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "customer_category_id")
    public String getCustomerCategoryId() {
        return customerCategoryId;
    }

    public void setCustomerCategoryId(String customerCategoryId) {
        this.customerCategoryId = customerCategoryId;
    }
}
