/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dto;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Each object of this class holds one of the possible invoice 
 * or delivery countries of customers.
 * @author Claudius Haecker
 */
@Entity
@Table(name = "country")
public class Country implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1577944261439810380L;
    private String countryId;
    private String name;
    private String isoCode;
    private Date dateCreated;
    private Date dateLastModified;

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "country_id", nullable = false)
    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    @Column(name = "name", nullable = false)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "iso_code", length = 2, nullable = false)
    public String getIsoCode() {
        if (isoCode == null) {
            isoCode = "";
        }
        return isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * Constructor which sets all properties - no checks are performed
     * @param countryId
     * @param name
     * @param isoCode
      * @param dateCreated the date set by the database on each row when <code>this</code> was inserted into the database.
     * @param dateLastModified the date (as set by the database) when <code>this</code> was updated in the database the last time.
     */
    public Country(String countryId, String name, String isoCode, Date dateCreated, Date dateLastModified) {
        this.countryId = countryId;
        this.name = name;
        this.isoCode = isoCode;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
    }

    public Country() {
    }

    @Override
    public boolean equals(Object obj) {
        Country o = (Country) obj;
        return this.isoCode.equals(o.getIsoCode());
    }

    @Override
    /*
     * If two objects are equal according to the equals(Object) method, then
     * calling the hashCode method on each of the two objects must produce the
     * same integer result. (From Java� Platform Standard Ed. 6 JavaDoc)
     * 
     */
    public int hashCode() {
        return this.getIsoCode().hashCode();
    }
}
