/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Class representing discounts per customer category.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "customer_category_discount")
public class CustomerCategoryDiscount {

    /** primary key */
    private Long id;

    /** creation date */ 
    private Date dateCreated;
    /** last modification date */
    private Date dateLastModified;

    /** customer category key */
    private String categoryKey;
    /** discount rate */
    private float percentage;

    public CustomerCategoryDiscount() {
        super();
    }

    public CustomerCategoryDiscount(Long id) {
        super();
        this.id = id;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "customer_category_discount_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * 
     * returns the date set by the database on each row when <code>this</code> was inserted into the database.
     * @return the creation date
     */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @return the dateLastModified
     */
    @Column(name = "date_last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     *  This method is for setting the date according to the date when <code>this</code> was updated in the database the last time.
     * @param dateLastModified
     */
    public void setDateLastModified(Date dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    /**
     * @return the categoryKey
     */
    @Column(name = "customer_category_key")
    public String getCategoryKey() {
        return categoryKey;
    }

    /**
     * @param categoryKey the categoryKey to set
     */
    public void setCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
    }

    /**
     * @return the percentage
     */
    @Column(name = "customer_category_discount_percentage")
    public float getPercentage() {
        return percentage;
    }

    /**
     * @param percentage the percentage to set
     */
    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

}
