/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class VolumeDiscountDaoImpl extends HibernateDaoSupport implements VolumeDiscountDao {

    private static final Logger LOG = Logger.getLogger(VolumeDiscountDaoImpl.class);
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.VolumeDiscountDao#getAll()
     */
    /* @Override */
    public List<VolumeDiscount> getAll() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAll()");
        }
        
        List<VolumeDiscount> volumeDiscountList = null;
        try {
            volumeDiscountList = getHibernateTemplate().find("from VolumeDiscount vd order by vd.fromQuantity");
        } catch (DataAccessException e) {
            LOG.error("Failed to load all VolumeDiscounts", e);
            throw new DaoException(e);
        }
        return volumeDiscountList;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.VolumeDiscountDao#findByQuantity()
     */
    /* @Override */
    public VolumeDiscount findByQuantity(int productQuantity) throws DaoException {
        
    	long start         = 0;
		long stop          = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("findByQuantity()");
        }
        
        VolumeDiscount volumeDiscount = null;
        List<VolumeDiscount> volumeDiscountList = null;
        try {
            volumeDiscountList = getHibernateTemplate().find(
                    "from VolumeDiscount vd " +
                    "where (vd.fromQuantity<=? or vd.fromQuantity=null) and (vd.toQuantity>=? or vd.toQuantity=null)",
                    new Object[] {productQuantity, productQuantity});
            if (volumeDiscountList == null) {
                LOG.error("Failed to find VolumeDiscount for product quantity: result list is null");
                throw new DaoException();
            }
            if (volumeDiscountList.size() > 1) {
                LOG.error("Failed to find VolumeDiscount for product quantity: unexpected result list length");
                throw new DaoException();
            }
        } catch (DataAccessException e) {
            LOG.error("Failed to find VolumeDiscount for product quantity", e);
            throw new DaoException(e);
        }
        if (volumeDiscountList.size() == 1) {
            volumeDiscount = volumeDiscountList.get(0);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "findByQuantity", start, stop);
        }
        return volumeDiscount;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.VolumeDiscountDao#save()
     */
    /* @Override */
    public void save(List<VolumeDiscount> volumeDiscountsList) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("save()");
        }
        
        try {
            getHibernateTemplate().saveOrUpdateAll(volumeDiscountsList);
        } catch (DataAccessException e) {
            LOG.error("Failed to save the list of VolumeDiscounts", e);
            throw new DaoException(e);
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.VolumeDiscountDao#delete()
     */
    /* @Override */
    public void delete(List<VolumeDiscount> volumeDiscountsList) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("delete()");
        }
        
        try {
            getHibernateTemplate().deleteAll(volumeDiscountsList);
        } catch (DataAccessException e) {
            LOG.error("Failed to delete the list of VolumeDiscounts", e);
            throw new DaoException(e);
        }
    }

}
