/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount}.
 * Allows to load all stored VolumeDiscounts and to find VolumeDiscount for a given product quantity.
 * 
 * @author Wladimir Safonov
 *
 */
public interface VolumeDiscountDao {
    
    /**
     * Loads a list of all stored
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * 
     * @return list of all stored
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * @throws DaoException if data access results in an error
     */
    public List<VolumeDiscount> getAll() throws DaoException;
    
    /**
     * Finds an applicable 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount}
     * for the given product quantity.
     * 
     * @param productQuantity product quantity of the volume discount
     * @return applicable {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount} 
     * @throws DaoException if data access results in an error
     */
    public VolumeDiscount findByQuantity(int productQuantity) throws DaoException;
    
    /**
     * Stores all 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * from the list to the database, updating or inserting new VolumeDiscounts as needed. Instances 
     * with existing Id will be updated, instances without Id will be inserted and their Id's will be
     * auto-generated. After the invocation each newly persisted instance will contain the generated Id.
     * 
     * @param volumeDiscountsList list of 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * to be stored
     * @throws DaoException if data access results in an error
     */
    public void save(List<VolumeDiscount> volumeDiscountsList) throws DaoException;
    
    /**
     * Removes all given
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * in the list from the database.
     * 
     * @param volumeDiscountsList list of
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.VolumeDiscount VolumeDiscounts}
     * to be deleted
     * @throws DaoException if data access results in an error
     */
    public void delete(List<VolumeDiscount> volumeDiscountsList) throws DaoException;
    
}
