/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class ProductPriceDaoImpl extends HibernateDaoSupport implements ProductPriceDao {

    private static final Logger LOG = Logger.getLogger(ProductPriceDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.ProductPriceDao#findProductCountryPrice(java.lang.String, java.lang.String)
     */
    /* @Override */
    public ProductPrice findCountryPrice(String productCode, String countryCode) throws DaoException {
        
    	long start         = 0;
		long stop          = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("findCountryPrice()");
        }

        ProductPrice productPrice = null;
        List productPriceList;
        try {
            productPriceList = getHibernateTemplate().find(
                    "from ProductPrice pp where pp.productCode=? and (pp.countryIsoCode=? or pp.countryIsoCode=null)",
                    new Object[] { productCode, countryCode });
            if (productPriceList == null) {
                LOG.error("Failed to find ProductPrice for country: result list is null");
                throw new DaoException();
            }
            if (productPriceList.size() > 2) {
                LOG.error("Failed to find ProductPrice for country: unexpected result list length");
                throw new DaoException();
            }
        } catch (DataAccessException e) {
            LOG.error("Failed to find ProductPrice for country", e);
            throw new DaoException(e);
        }

        if (productPriceList.size() > 0) {
            productPrice = (ProductPrice) productPriceList.get(0);
            // check for a country-specific price
            if (productPriceList.size() == 2 && productPrice.isStandardPrice()) {
                productPrice = (ProductPrice) productPriceList.get(1);
            }
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "findCountryPrice", start, stop);
        }
        
        return productPrice;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.ProductPriceDao#getAllCountryPrices()
     */
    /* @Override */
    public List<ProductPrice> getAllCountryPrices() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllCountryPrices()");
        }

        List<ProductPrice> productPrices = null;
        try {
            productPrices = getHibernateTemplate().find("from ProductPrice pp where pp.countryIsoCode<>null");
        } catch (DataAccessException e) {
            LOG.error("Failed to load the list of all ProductPrices", e);
            throw new DaoException(e);
        }
        return productPrices;
    }

}
