/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice}.
 * Allows to find country-specific ProductPrice for a given product.
 * 
 * @author Wladimir Safonov
 *
 */
public interface ProductPriceDao {

    /**
     * Finds a country-specific product price. If there is no country-specific price, 
     * the product standard price will be taken.
     * 
     * @param productCode code of the product to look the price for
     * @param countryCode ISO country code to look the product price for
     * @return country-specific or standard 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.ProductPrice} 
     * @throws DaoException if data access results in an error
     */
    public ProductPrice findCountryPrice(String productCode, String countryCode) throws DaoException;
    
    /**
     * Loads a list of all stored country-specific prices for all products. 
     * Product standard prices are not included.
     * 
     * @return list of all country-specific prices for all products
     * @throws DaoException if data access results in an error
     */
    public List<ProductPrice> getAllCountryPrices() throws DaoException;
    
}
