/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class CustomerTypeDiscountDaoImpl extends HibernateDaoSupport implements CustomerTypeDiscountDao {

    private static final Logger LOG = Logger.getLogger(CustomerTypeDiscountDaoImpl.class);
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.CustomerTypeDiscountDao#getByName(java.lang.String)
     */
    /* @Override */
    public CustomerTypeDiscount getByName(String customerType) throws DaoException {
        
    	long start         = 0;
		long stop          = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getByName()");
        }
        
        // check parameters
        if (null == customerType) {
            LOG.warn("CustomerTypeName parameter is null -> setting to empty string");
            customerType = "";
        }
        
        CustomerTypeDiscount customerTypeDiscount = null;
        List<CustomerTypeDiscount> customerTypeDiscounts = null;
        try {
            customerTypeDiscounts = getHibernateTemplate().find(
                    "from CustomerTypeDiscount ctd where ctd.customerType=?", customerType);
            if (customerTypeDiscounts == null) {
                LOG.error("Failed to find CustomerTypeDiscount: result list is null");
                throw new DaoException();
            }
            if (customerTypeDiscounts.size() > 1) {
                LOG.error("Failed to find CustomerTypeDiscount: unexpected result list length");
                throw new DaoException();
            }
        } catch (DataAccessException e) {
            LOG.error("Failed to load CustomerTypeDiscount by its name", e);
            throw new DaoException(e);
        }
        
        if (customerTypeDiscounts.size() == 1) {
            customerTypeDiscount = customerTypeDiscounts.get(0);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getByName: " + customerType, start, stop);
        }
        
        return customerTypeDiscount;
    }

    /* @Override */
    public List<CustomerTypeDiscount> getAll() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAll()");
        }
        
        List<CustomerTypeDiscount> typeDiscounts = null;
        try {
            typeDiscounts = getHibernateTemplate().find("from CustomerTypeDiscount");
        } catch (DataAccessException e) {
            throw new DaoException(e);
        }
        return typeDiscounts;
    }

}
