/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount}.
 * Allows to find country-specific ProductPrice for a given product.
 * 
 * @author Wladimir Safonov
 *
 */
public interface CustomerTypeDiscountDao {

    /**
     * Finds customer type by its name
     * 
     * @param customerType name of the customer type
     * @return {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount}
     * of the given name
     */
    public CustomerTypeDiscount getByName(String customerType) throws DaoException;
    
    /**
     * Loads a list of all stored
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount CustomerTypeDiscounts}
     * 
     * @return list of all stored
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerTypeDiscount CustomerTypeDiscounts}
     * @throws DaoException if data access results in an error
     */
    public List<CustomerTypeDiscount> getAll() throws DaoException;
}
