/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.awt.geom.IllegalPathStateException;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class CustomerCategoryDiscountDaoImpl extends HibernateDaoSupport implements CustomerCategoryDiscountDao {

    private static final Logger LOG = Logger.getLogger(CustomerCategoryDiscountDaoImpl.class);
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.CustomerCategoryDiscountDao#getAll()
     */
    @SuppressWarnings("unchecked")
    /*  @Override  */
    public List<CustomerCategoryDiscount> getAll() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAll()");    
        }
        
        List<CustomerCategoryDiscount> customerCategoryDiscountList = null;
        try {
            customerCategoryDiscountList = getHibernateTemplate().find("from CustomerCategoryDiscount");
        } catch (DataAccessException e) {
            LOG.error("Failed to load all CustomerCategoryDiscounts", e);
            throw new DaoException(e);
        }
        return customerCategoryDiscountList;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pricing_simulator.be.dao.CustomerCategoryDiscountDao#getByKey()
     */
    @SuppressWarnings("unchecked")
    /* @Override  */
    public CustomerCategoryDiscount getByCategoryKey(String key) throws DaoException {
		
    	long start         = 0;
		long stop          = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("getByCategoryKey()");    
        }
        
        // check parameters
        if (null == key) {
            LOG.warn("CategoryKey parameter is null -> setting to empty string");
            key = "";
        }
        
        CustomerCategoryDiscount customerCategoryDiscount = null;
        List<CustomerCategoryDiscount> categoryDiscountList = null;
        try {
            categoryDiscountList = getHibernateTemplate().find("from CustomerCategoryDiscount ccd where ccd.categoryKey=?",
                    key);
            if (categoryDiscountList == null) {
                LOG.error("Failed to find CustomerCategoryDiscount by key: result list is null");
                throw new DaoException();
            }
            if (categoryDiscountList.size() > 1) {
                LOG.error("Failed to find CustomerCategoryDiscount by key: unexpected result list length");
                throw new DaoException();
            }
        } catch (DataAccessException e) {
            LOG.error("Failed to find CustomerCategoryDiscount by key", e);
            throw new DaoException(e);
        }
        if (categoryDiscountList.size() == 1) {
            customerCategoryDiscount = categoryDiscountList.get(0);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getByCategoryKey: " + key, start, stop);
        }
        
        return customerCategoryDiscount;
    }

}
