/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pricing_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount;
import de.itemis.qimpress.showcase.pricing_simulator.be.exceptions.DaoException;

/**
 * DAO-operations interface for {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount}.
 * Allows to load all stored CustomerCategoryDiscounts and to find CustomerCategoryDiscount for a given category.
 * 
 * @author Wladimir Safonov
 *
 */
public interface CustomerCategoryDiscountDao {

    /**
     * Loads a list of all stored 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount CustomerCategoryDiscounts}.
     * 
     * @return list of all stored 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount CustomerCategoryDiscounts}
     * @throws DaoException if data access results in an error
     */
    public List<CustomerCategoryDiscount> getAll() throws DaoException;
    
    /**
     * Finds 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount}
     * by its key.
     * 
     * @param key key for the category to find discount for
     * @return 
     * {@link de.itemis.qimpress.showcase.pricing_simulator.be.domain.CustomerCategoryDiscount}
     * for the given key
     * @throws DaoException if data access results in an error
     */
    public CustomerCategoryDiscount getByCategoryKey(String key) throws DaoException;
    
}
