--
-- PostgreSQL database dump
--

-- Started on 2008-12-01 14:11:39

DROP PROCEDURAL LANGUAGE IF EXISTS plpgsql; 
CREATE PROCEDURAL LANGUAGE plpgsql;

--
-- TOC entry 18 (class 1255 OID 158312)
-- Dependencies: 4 271
-- Name: update_created_column(); Type: FUNCTION; Schema: public; Owner: pricing_user
--

CREATE FUNCTION update_created_column() RETURNS "trigger"
    AS 'BEGIN NEW.date_created = now(); RETURN NEW; END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_created_column() OWNER TO pricing_user;

--
-- TOC entry 1642 (class 0 OID 0)
-- Dependencies: 18
-- Name: FUNCTION update_created_column(); Type: COMMENT; Schema: public; Owner: pricing_user
--

COMMENT ON FUNCTION update_created_column() IS 'Sets date_created to the current date. Should be triggered on  INSERT.';


--
-- TOC entry 19 (class 1255 OID 158313)
-- Dependencies: 271 4
-- Name: update_modified_column(); Type: FUNCTION; Schema: public; Owner: pricing_user
--

CREATE FUNCTION update_modified_column() RETURNS "trigger"
    AS 'BEGIN NEW.date_last_modified = now(); RETURN NEW; END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_modified_column() OWNER TO pricing_user;

--
-- TOC entry 1643 (class 0 OID 0)
-- Dependencies: 19
-- Name: FUNCTION update_modified_column(); Type: COMMENT; Schema: public; Owner: pricing_user
--

COMMENT ON FUNCTION update_modified_column() IS 'Sets date_last_modified to the current date. Should be triggered on UPDATE.';

--
-- TOC entry 1276 (class 1259 OID 197442)
-- Dependencies: 4
-- Name: currency; Type: TABLE; Schema: public; Owner: pricing_user; Tablespace: 
--

CREATE TABLE currency (
    currency_id bigint NOT NULL,
    currency_sign character varying(255),
    currency_iso_code character varying(255) NOT NULL,
    date_created timestamp without time zone NOT NULL,
    date_last_modified timestamp without time zone NOT NULL
);


ALTER TABLE public.currency OWNER TO pricing_user;

--
-- TOC entry 1277 (class 1259 OID 197451)
-- Dependencies: 4
-- Name: customer_category_discount; Type: TABLE; Schema: public; Owner: pricing_user; Tablespace: 
--

CREATE TABLE customer_category_discount (
    customer_category_discount_id bigint NOT NULL,
    customer_category_discount_percentage real,
    date_created timestamp without time zone NOT NULL,
    date_last_modified timestamp without time zone NOT NULL,
    customer_category_key character varying(255)
);


ALTER TABLE public.customer_category_discount OWNER TO pricing_user;

--
-- TOC entry 1278 (class 1259 OID 197455)
-- Dependencies: 4
-- Name: customer_type_discount; Type: TABLE; Schema: public; Owner: pricing_user; Tablespace: 
--

CREATE TABLE customer_type_discount (
    customer_type_discount_id bigint NOT NULL,
    customer_type_discount_percentage real,
    customer_type character varying(255),
    date_created timestamp without time zone NOT NULL,
    date_last_modified timestamp without time zone NOT NULL
);


ALTER TABLE public.customer_type_discount OWNER TO pricing_user;

--
-- TOC entry 1281 (class 1259 OID 197477)
-- Dependencies: 4
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: pricing_user
--

CREATE SEQUENCE hibernate_sequence
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO pricing_user;

--
-- TOC entry 1279 (class 1259 OID 197461)
-- Dependencies: 4
-- Name: product_price; Type: TABLE; Schema: public; Owner: pricing_user; Tablespace: 
--

CREATE TABLE product_price (
    product_price_id bigint NOT NULL,
    product_price numeric(19,2),
    product_code character varying(255),
    country_iso_code character varying(255),
    date_created timestamp without time zone NOT NULL,
    date_last_modified timestamp without time zone NOT NULL,
    product_price_currency bigint
);


ALTER TABLE public.product_price OWNER TO pricing_user;

--
-- TOC entry 1280 (class 1259 OID 197468)
-- Dependencies: 4
-- Name: volume_discount; Type: TABLE; Schema: public; Owner: pricing_user; Tablespace: 
--

CREATE TABLE volume_discount (
    volume_discount_id bigint NOT NULL,
    volume_discount_percentage real,
    date_created timestamp without time zone NOT NULL,
    date_last_modified timestamp without time zone NOT NULL,
    volume_discount_from_quantity integer,
    volume_discount_to_quantity integer
);


ALTER TABLE public.volume_discount OWNER TO pricing_user;

--
-- TOC entry 1613 (class 2606 OID 197450)
-- Dependencies: 1276 1276
-- Name: currency_currency_iso_code_key; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY currency
    ADD CONSTRAINT currency_currency_iso_code_key UNIQUE (currency_iso_code);


--
-- TOC entry 1615 (class 2606 OID 197448)
-- Dependencies: 1276 1276
-- Name: currency_pkey; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY currency
    ADD CONSTRAINT currency_pkey PRIMARY KEY (currency_id);


--
-- TOC entry 1617 (class 2606 OID 197454)
-- Dependencies: 1277 1277
-- Name: customer_category_discount_pkey; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY customer_category_discount
    ADD CONSTRAINT customer_category_discount_pkey PRIMARY KEY (customer_category_discount_id);


--
-- TOC entry 1619 (class 2606 OID 197460)
-- Dependencies: 1278 1278
-- Name: customer_type_discount_customer_type_key; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY customer_type_discount
    ADD CONSTRAINT customer_type_discount_customer_type_key UNIQUE (customer_type);


--
-- TOC entry 1621 (class 2606 OID 197458)
-- Dependencies: 1278 1278
-- Name: customer_type_discount_pkey; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY customer_type_discount
    ADD CONSTRAINT customer_type_discount_pkey PRIMARY KEY (customer_type_discount_id);


--
-- TOC entry 1623 (class 2606 OID 197467)
-- Dependencies: 1279 1279
-- Name: product_price_pkey; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY product_price
    ADD CONSTRAINT product_price_pkey PRIMARY KEY (product_price_id);


--
-- TOC entry 1625 (class 2606 OID 197471)
-- Dependencies: 1280 1280
-- Name: volume_discount_pkey; Type: CONSTRAINT; Schema: public; Owner: pricing_user; Tablespace: 
--

ALTER TABLE ONLY volume_discount
    ADD CONSTRAINT volume_discount_pkey PRIMARY KEY (volume_discount_id);


--
-- TOC entry 1627 (class 2620 OID 197517)
-- Dependencies: 18 1276
-- Name: trigger_created_currency; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_created_currency
    BEFORE INSERT ON currency
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1629 (class 2620 OID 197495)
-- Dependencies: 18 1277
-- Name: trigger_created_customer_category_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_created_customer_category_discount
    BEFORE INSERT ON customer_category_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1631 (class 2620 OID 197499)
-- Dependencies: 18 1278
-- Name: trigger_created_customer_type_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_created_customer_type_discount
    BEFORE INSERT ON customer_type_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1633 (class 2620 OID 197519)
-- Dependencies: 18 1279
-- Name: trigger_created_product_price; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_created_product_price
    BEFORE INSERT ON product_price
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1635 (class 2620 OID 197496)
-- Dependencies: 1280 18
-- Name: trigger_created_volume_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_created_volume_discount
    BEFORE INSERT ON volume_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1628 (class 2620 OID 197518)
-- Dependencies: 19 1276
-- Name: trigger_modified_currency; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_modified_currency
    BEFORE INSERT OR UPDATE ON currency
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1630 (class 2620 OID 197497)
-- Dependencies: 19 1277
-- Name: trigger_modified_customer_category_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_modified_customer_category_discount
    BEFORE INSERT OR UPDATE ON customer_category_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1632 (class 2620 OID 197500)
-- Dependencies: 19 1278
-- Name: trigger_modified_customer_type_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_modified_customer_type_discount
    BEFORE INSERT OR UPDATE ON customer_type_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1634 (class 2620 OID 197520)
-- Dependencies: 19 1279
-- Name: trigger_modified_product_price; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_modified_product_price
    BEFORE INSERT OR UPDATE ON product_price
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1636 (class 2620 OID 197498)
-- Dependencies: 19 1280
-- Name: trigger_modified_volume_discount; Type: TRIGGER; Schema: public; Owner: pricing_user
--

CREATE TRIGGER trigger_modified_volume_discount
    BEFORE INSERT OR UPDATE ON volume_discount
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1626 (class 2606 OID 197472)
-- Dependencies: 1276 1614 1279
-- Name: fk527231f9231fe2af; Type: FK CONSTRAINT; Schema: public; Owner: pricing_user
--

ALTER TABLE ONLY product_price
    ADD CONSTRAINT fk527231f9231fe2af FOREIGN KEY (product_price_currency) REFERENCES currency(currency_id);


--
-- TOC entry 1641 (class 0 OID 0)
-- Dependencies: 4
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2008-12-01 14:11:40

--
-- PostgreSQL database dump complete
--

