/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.jsf.beans;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeType;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;

/**
 * @author Claudius Haecker
 *
 */
public class PdmSimulatorFeControllerTest {
    private static final Logger LOG = Logger.getLogger(PdmSimulatorFeControllerTest.class);

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    /**
     * Test method for {@link de.itemis.qimpress.showcase.pdm_simulator.jsf.beans.PdmSimulatorFeController#getProductAttributes()}.
     */
    @Test
    public void testGetProductAttributes() {
        PdmSimulatorFeController controller = null;
        try {
            controller = new PdmSimulatorFeController();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
        try {
            controller.updateDataForProduct("-13");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }
        List<AttributeValue> attribs = controller.getProductAttributes();
        assertEquals(7, attribs.size());
        AttributeValue acousticPowerEmissions = attribs.get(0);
        assertEquals("6.5 B(A)", acousticPowerEmissions.getAttributeValueText());
        assertEquals("Acoustic Power Emissions", acousticPowerEmissions.getAttributeDefinition()
                .getAttributeDefinitionName());
        AttributeType type = acousticPowerEmissions.getAttributeDefinition().getAttributeType();
        assertEquals("free text", type.getAttributeTypeKey());

    }
}
