/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.webservice.dto;

import java.util.List;

/**
 * Transfer Object class combining all information about the product. Used in Web Service
 * interface to return in one go data of the product and its corresponding product group.
 * 
 * @author Wladimir Safonov
 *
 */
public class ProductInfo {

    private String productCode;
    private String productName;
    private String productGroupCode;
    private String productGroupName;
    private String productGroupDescription;
    private List<AttributeInfo> attributes;
    
    /**
     * @return the productCode
     */
    public String getProductCode() {
        return productCode;
    }

    /**
     * @param productCode the productCode to set
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /**
     * @return the productName
     */
    public String getProductName() {
        return productName;
    }

    /**
     * @param productName the productName to set
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * @return the productGroupCode
     */
    public String getProductGroupCode() {
        return productGroupCode;
    }

    /**
     * @param productGroupCode the productGroupCode to set
     */
    public void setProductGroupCode(String productGroupCode) {
        this.productGroupCode = productGroupCode;
    }

    /**
     * @return the productGroupName
     */
    public String getProductGroupName() {
        return productGroupName;
    }

    /**
     * @param productGroupName the productGroupName to set
     */
    public void setProductGroupName(String productGroupName) {
        this.productGroupName = productGroupName;
    }
    
    /**
     * @return the productGroupDescription
     */
    public String getProductGroupDescription() {
        return productGroupDescription;
    }
    
    /**
     * @param productGroupDescription the productGroupDescription to set
     */
    public void setProductGroupDescription(String productGroupDescription) {
        this.productGroupDescription = productGroupDescription;
    }

    /**
     * @return the attributes
     */
    public List<AttributeInfo> getAttributes() {
        return attributes;
    }

    /**
     * @param attributes the attributes to set
     */
    public void setAttributes(List<AttributeInfo> attributes) {
        this.attributes = attributes;
    }
    
    
}
