/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.webservice.dto;

/**
 * Transfer Object class combining all information about the product attribute.
 * Used in the Web Service to return attribute data in compact format.
 * 
 * @author Wladimir Safonov
 *
 */
public class AttributeInfo {

    private String attributeDefinitionCode;
    private String attributeDefinitionName;
    private String attributeDefinitionDescription;
    private String attributeTypeKey;
    private String attributeValue;
    
    
    /**
     * @return the attributeDefinitionName
     */
    public String getAttributeDefinitionName() {
        return attributeDefinitionName;
    }

    /**
     * @param attributeDefinitionName the attributeDefinitionName to set
     */
    public void setAttributeDefinitionName(String attributeDefinitionName) {
        this.attributeDefinitionName = attributeDefinitionName;
    }

    /**
     * @return the attributeDefinitionDescription
     */
    public String getAttributeDefinitionDescription() {
        return attributeDefinitionDescription;
    }

    /**
     * @param attributeDefinitionDescription the attributeDefinitionDescription to set
     */
    public void setAttributeDefinitionDescription(String attributeDefinitionDescription) {
        this.attributeDefinitionDescription = attributeDefinitionDescription;
    }

    /**
     * @return the attributeTypeKey
     */
    public String getAttributeTypeKey() {
        return attributeTypeKey;
    }

    /**
     * @param attributeTypeKey the attributeTypeKey to set
     */
    public void setAttributeTypeKey(String attributeTypeKey) {
        this.attributeTypeKey = attributeTypeKey;
    }

    /**
     * @return the attributeValue
     */
    public String getAttributeValue() {
        return attributeValue;
    }

    /**
     * @param attributeValue the attributeValue to set
     */
    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }
    
    /**
     * @return the attributeDefinitionCode
     */
    public String getAttributeDefinitionCode() {
        return attributeDefinitionCode;
    }
    
    /**
     * @param attributeDefinitionCode the attributeDefinitionCode to set
     */
    public void setAttributeDefinitionCode(String attributeDefinitionCode) {
        this.attributeDefinitionCode = attributeDefinitionCode;
    }
    
}
