/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.webservice;

import static org.apache.commons.lang.Validate.notEmpty;
import static org.apache.commons.lang.Validate.notNull;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager;
import de.itemis.qimpress.showcase.pdm_simulator.be.service.ServiceLocator;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.dto.AttributeInfo;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.dto.ProductInfo;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetAttributesByProductIDRequest;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetAttributesByProductIDResponse;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductGroupByIDRequest;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductGroupByIDResponse;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductGroupRootRequest;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductGroupRootResponse;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductInfoRequest;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductInfoResponse;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductsByProductGroupIDRequest;
import de.itemis.qimpress.showcase.pdm_simulator.webservice.messages.GetProductsByProductGroupIDResponse;

/**
 * Endpoint for PDM Webservice with XML auto-marshalling
 * 
 * @author Wladimir Safonov
 *
 */
@Endpoint
public class PdmMarshallingEndpoint {

    private static final Logger LOG = Logger.getLogger(PdmMarshallingEndpoint.class);

    private PDMManager pdmManager = ServiceLocator.getInstance().getPDMManager();
    
    public PdmMarshallingEndpoint() {
        
    }

    @PayloadRoot(localPart="GetProductGroupRootRequest", namespace="http://www.itemis.com/pdm/schemas")
    public GetProductGroupRootResponse getProductGroupRoot(GetProductGroupRootRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WS method getProductGroupRoot called");
        }
        
        GetProductGroupRootResponse response = new GetProductGroupRootResponse();
        response.setRootProductGroup(pdmManager.getProductGroupRoot());
        return response;
    }
    
    @PayloadRoot(localPart="GetProductGroupByIDRequest", namespace="http://www.itemis.com/pdm/schemas")
    public GetProductGroupByIDResponse getProductGroupByID(GetProductGroupByIDRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WS method getProductGroupByID called");
        }
        
        GetProductGroupByIDResponse response = new GetProductGroupByIDResponse();
        response.setProductGroup(pdmManager.getProductGroupByID(request.getProductGroupID()));
        return response;
    }

    @PayloadRoot(localPart="GetProductsByProductGroupIDRequest", namespace="http://www.itemis.com/pdm/schemas")
    public GetProductsByProductGroupIDResponse getProductsByProductGroupID(GetProductsByProductGroupIDRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WS method getProductGroupByID called");
        }
        
        GetProductsByProductGroupIDResponse response = new GetProductsByProductGroupIDResponse();
        response.setProducts(pdmManager.getProducts(request.getProductGroupID()));
        return response;
    }
    
    @PayloadRoot(localPart="GetAttributesByProductIDRequest", namespace="http://www.itemis.com/pdm/schemas")
    public GetAttributesByProductIDResponse getAttributesByProductID(GetAttributesByProductIDRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("WS method getProductGroupByID called");
        }
        
        GetAttributesByProductIDResponse response = new GetAttributesByProductIDResponse();
        response.setAttributeValues(pdmManager.getAttributes(request.getProductID()));
        return response;
    }
    
    @PayloadRoot(localPart="GetProductInfoRequest", namespace="http://www.itemis.com/pdm/schemas")
    public GetProductInfoResponse getProductInfo(GetProductInfoRequest request) throws Exception {
        
		long   start = 0;
		long   stop  = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	if (LOG.isDebugEnabled()) {
            LOG.debug("WS method getProductInfo called");
        }
        
        // validate input parameter
        notNull(request, "Request object is null");
        notEmpty(request.getProductCode(), "ProductCode parameter is empty");
        
        GetProductInfoResponse response = new GetProductInfoResponse();
        Product product = pdmManager.getProductByCode(request.getProductCode());
        if (product != null) {
            
            // copy product data
            ProductInfo productInfo = new ProductInfo();
            productInfo.setProductCode(product.getProductCode());
            productInfo.setProductName(product.getProductName());
            productInfo.setProductGroupCode(product.getProductGroup().getProductGroupCode());
            productInfo.setProductGroupName(product.getProductGroup().getProductGroupName());
            productInfo.setProductGroupDescription(product.getProductGroup().getProductGroupDescription());

            // copy attributes data
            List<AttributeInfo> attributes = new LinkedList<AttributeInfo>();
            for (AttributeValue attrValue : product.getAttributeValues()) {
                AttributeInfo attrInfo = new AttributeInfo();
                attrInfo.setAttributeDefinitionCode(attrValue.getAttributeDefinition().getAttributeDefinitionCode());
                attrInfo.setAttributeDefinitionName(attrValue.getAttributeDefinition().getAttributeDefinitionName());
                attrInfo.setAttributeDefinitionDescription(attrValue.getAttributeDefinition().getAttributeDefinitionDescription());
                attrInfo.setAttributeTypeKey(attrValue.getAttributeDefinition().getAttributeType().getAttributeTypeKey());
                attrInfo.setAttributeValue(attrValue.getAttributeValueText());
                attributes.add(attrInfo);
            }
            productInfo.setAttributes(attributes);
            
            response.setProductInfo(productInfo);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "GetProductInfoRequest", start, stop);
        	Meassurements.log();
        }
        return response;
    }
}
