/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.webservice;

import java.util.List;
import java.util.Random;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint;

import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;


/**
 * PDM Webservice Endpoint for service methods designated for 
 * Order Shipment Generator. Allows to request for a random
 * product number taken from the stored products.
 * 
 * @author Wladimir Safonov
 *
 */
public class Pdm4OsgJDomEndpoint extends AbstractJDomPayloadEndpoint {

    private static final Logger LOG = Logger.getLogger(Pdm4OsgJDomEndpoint.class);
    
    // Payload root elements names
    public static final String GET_RANDOM_PRODUCT_CODE_REQUEST = "GetRandomProductCodeRequest";
    public static final String GET_RANDOM_PRODUCT_CODE_RESPONSE = "GetRandomProductCodeResponse";

    // PDM WebService Namespace
    private static final Namespace PDM_NAMESPACE = Namespace.getNamespace("pdm", "http://www.itemis.com/pdm/schemas");

    private JdbcTemplate jdbcTemplate;
    private Random random = new Random();
    /**
     * @param jdbcTemplate the jdbcTemplate to set
     */
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }


    /* (non-Javadoc)
     * @see org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint#invokeInternal(org.jdom.Element)
     */
    @Override
    protected Element invokeInternal(Element request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called invokeInternal()"); 
        }
        
        String rootElementName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("detected request root element: " + rootElementName); 
        }
        if (GET_RANDOM_PRODUCT_CODE_REQUEST.equals(rootElementName)) {
            
            // load the list of product codes
            List<String> productCodes = null;
            try {
                productCodes = jdbcTemplate.queryForList("SELECT product_code FROM product", String.class);
            } catch (DataAccessException e) {
                LOG.error("Failed to load the list of stored product codes", e);
                throw new ApplicationException(ApplicationErrorCode.TE, e);
            }
            
            // pick up a random product code
            String randomProductCode = productCodes.get(random.nextInt(productCodes.size()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Picked up random product code: " + randomProductCode);
            }
            
            // create a response element
            return createGetRandomProductCodeResponse(randomProductCode);
        }
        return null;
    }
    
    private Element createGetRandomProductCodeResponse(String productCode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called createGetRandomProductCodeResponse()");
        }
        
        // create response element
        Element responseRoot = new Element(GET_RANDOM_PRODUCT_CODE_RESPONSE, PDM_NAMESPACE);
        responseRoot.addContent(new Element("ProductCode", PDM_NAMESPACE).setText(productCode));
        
        return responseRoot;
    }

}
