/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.servlet;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;

import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager;
import de.itemis.qimpress.showcase.pdm_simulator.be.service.ServiceLocator;

public class BinaryFileServlet extends HttpServlet {

    private static final Logger LOG = Logger.getLogger(BinaryFileServlet.class);

    private static final int DEFAULT_BUFFER_SIZE = 10240; // 10KB.

    private static final PDMManager PDM_MANAGER= ServiceLocator.getInstance().getPDMManager();
    


    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        
        // get resource ID from the request
        String resourceId = req.getParameter("id");

        // Check if ID is supplied to the request.
        if (resourceId == null) {
            // TODO: redirect to not found page
            return;
        }

        // Lookup binary attribute in database.
        AttributeBinaryValue attrBinaryValue = PDM_MANAGER.getAttributeBinaryValueById(resourceId);

        // Check if the binary attribute value is actually retrieved from database.
        if (attrBinaryValue == null) {
            // TODO: redirect to NOT_FOUND page
            return;
        }
        
        // Prepare streams.
        BufferedOutputStream output = null;

        try {
            // Init servlet response.
            resp.reset();
            resp.setContentType(attrBinaryValue.getMimeType());
            resp.setContentLength(attrBinaryValue.getBinaryData().length);
            resp.setHeader("Content-disposition", "inline; filename=\"" + attrBinaryValue.getFileName() + "\"");
            output = new BufferedOutputStream(resp.getOutputStream(), DEFAULT_BUFFER_SIZE);

            output.write(attrBinaryValue.getBinaryData());
            
            // Write file contents to response.
//            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
//            for (int length; (length = input.read(buffer)) != -1;) {
//                output.write(buffer, 0, length);
//            }

            // Finalize task.
            output.flush();
        } finally {
            // Gently close streams.
            close(output);
        }
    }
    
    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            } catch (IOException e) {
                LOG.error("Failed to close OutputStream", e);
            }
        }
    }

}
