/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.jsf.beans;
import javax.swing.tree.DefaultMutableTreeNode;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;

/**
 * @author Claudius Haecker
 *
 */
public class ExtendedDefaultMutableTreeNode extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -8952831481165422432L;
    private static final Logger LOG = Logger.getLogger(ExtendedDefaultMutableTreeNode.class);
    ProductGroup productGroup;

    /**
     * @return the productGroup
     */
    public ProductGroup getProductGroup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroup");
        }
        return productGroup;
    }

    /**
     * @param productGroup the productGroup to set
     */
    public void setProductGroup(ProductGroup productGroup) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setProductGroup");
        }
        this.productGroup = productGroup;
    }

}
