/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.service;

import java.util.Collection;
import java.util.List;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test; // import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;
import static org.junit.Assert.*;

/**
 * @author Claudius Haecker
 *
 */
public class PDMManagerProductTest { //extends AbstractTransactionalDataSourceSpringContextTests {

    // test ... extends AbstractTransactionalHibernateTest or AbstractTransactionalSpringContextTests

    private static final Logger LOG = Logger.getLogger(PDMManagerProductTest.class);

    private static PDMManager pdm;

    //
    //    @Override
    //    protected String[] getConfigLocations() {
    //        // new String[] {"classpath*:/src/applicationContext.xml"};
    //        return new String[] {"classpath*:/**/applicationContext.xml"};
    //    }
    //

    // note: extending the test from AbstractTransactionalDataSourceSpringContextTests
    // Junit3 => no @Test annotations => the setUpBeforClass is not called,
    // so we have to instance the PDMManager in our first test method: 
    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setUpBeforeClass");
        }
        pdm = ServiceLocator.getInstance().getPDMManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("*** pdm : " + pdm);
        }
        assertNotNull(pdm);
    }

    /**
     * Tests that the PDMManager pdm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetPDM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetPDM");
        }
        PDMManager localPdm = ServiceLocator.getInstance().getPDMManager();
        assertNotNull(localPdm);
    }

    /**
     * Test method for
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManagerImpl#getProductGroups()}
     */
    @Test
    public void testGetProductGroupRoot() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetProductGroupRoot");
        }
        assertNotNull(pdm);
        ProductGroup rootProductGroup = null;
        try {
            rootProductGroup = pdm.getProductGroupRoot();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\t=> rootProductGroup ID          = " + rootProductGroup.getProductGroupId());
                LOG.debug("\t=> rootProductGroup CODE        = " + rootProductGroup.getProductGroupCode());
                LOG.debug("\t=> rootProductGroup NAME        = " + rootProductGroup.getProductGroupName());
                LOG.debug("\t=> rootProductGroup DESCRIPTION = " + rootProductGroup.getProductGroupDescription());
                LOG.debug("\t=> rootProductGroup PARENT      = " + rootProductGroup.getParentProductGroup());
                Collection<ProductGroup> childProductGroups = rootProductGroup.getChildProductGroups();
                LOG.debug("\t=> CHILD-ProductGroups-SIZE  = " + childProductGroups.size());
                for (ProductGroup pg : childProductGroups) {
                    LOG.debug("\t=> ProductGroupName = " + pg.getProductGroupName() + " - parentID:"
                            + pg.getParentProductGroup().getProductGroupId());
                }
            }
            assertEquals("ROOT", rootProductGroup.getProductGroupName());
            assertNull(rootProductGroup.getParentProductGroup());
            // for ROOT we expect 8 child product-groups:
            assertEquals(8, rootProductGroup.getChildProductGroups().size());
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
    }

    /**
     * Tests the PDMManager service method getProductGroupByID.
     */
    @Test
    public void testGetProductGroupByID() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetProductGroupByID");
        }
        ProductGroup rootPG = null;
        ProductGroup printerPG = null;
        try {
            rootPG = pdm.getProductGroupByID("-1");
            assertNotNull(rootPG);
            assertEquals("ROOT", rootPG.getProductGroupName());
            printerPG = pdm.getProductGroupByID("-2");
            assertNotNull(printerPG);
            assertEquals("Printer", printerPG.getProductGroupName());
            assertEquals(5, printerPG.getChildProductGroups().size());
        } catch (ApplicationException e) {
            LOG.error("ERROR - test failed!");
            e.printStackTrace();
            fail();
        }
    }

    /**
     * Tests the PDMManager service method getProducts
     * for the root product group and some other product groups.
     */
    @Test
    public void testGetProducts() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetProducts");
        }
        ProductGroup rootPG = null;
        List<Product> allProducts = null;
        String id = "";
        try {
            rootPG = pdm.getProductGroupRoot();
        } catch (ApplicationException e1) {
            // TODO Auto-generated catch block
            LOG.error("ERROR - test failed!");
            e1.printStackTrace();
            fail();
        }
        assertNotNull(rootPG);
        id = rootPG.getProductGroupId();
        try {
            allProducts = pdm.getProducts(id);
        } catch (ApplicationException e2) {
            LOG.error("ERROR - test failed!");
            e2.printStackTrace();
            fail();
        }
        assertNotNull(allProducts);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\tTEST - allProducts.size() = " + allProducts.size());
        }
        assertEquals(80, allProducts.size());
        ProductGroup printer = null;
        List<Product> allPrinterProducts = null;
        try {
            // product group 'Printer': ID = -2
            printer = pdm.getProductGroupByID("-2");
            assertNotNull(printer);
            allPrinterProducts = pdm.getProducts("-2");
            assertNotNull(allPrinterProducts);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\tTEST - allPrinterProducts.size() = " + allPrinterProducts.size());
            }
            // we expect 18 products for the 5 printer product groups
            assertEquals(18, allPrinterProducts.size());
        } catch (ApplicationException e) {
            LOG.error("ERROR - test failed!");
            e.printStackTrace();
            fail();
        }
        List<Product> allLaserColorProducts = null;
        try {
            // product group 'LaserColor': ID = -3
            allLaserColorProducts = pdm.getProducts("-3");
            assertNotNull(allLaserColorProducts);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\tTEST - allLaserColorProducts.size() = " + allLaserColorProducts.size());
            }
            // we expect 4 products for the product group LaserPrinter
            assertEquals(4, allLaserColorProducts.size());
        } catch (ApplicationException e) {
            LOG.error("ERROR - test failed!");
            e.printStackTrace();
            fail();
        }
    }
    
    @Test
    public void testGetProductByCode() {
        Product product = null;
        
        try {
            product = pdm.getProductByCode("SOMA005");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load Product by Code");
        }
        assertNotNull("Failed to load Product by Code: product is null", product);

        try {
            product = pdm.getProductByCode("NON-EXISTING");
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load non-existing Product by Code");
        }
        assertNull("Unxpected result while loading non-existing Product by Code", product);
    }
    
}
