/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeType;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;

/**
 * @author Claudius Haecker
 *
 */
public class PDMManagerAttributeTest {

    private static final Logger LOG = Logger.getLogger(PDMManagerAttributeTest.class);

    private static PDMManager pdm = ServiceLocator.getInstance().getPDMManager();

    /**
     * initializes pdm
     */
    @BeforeClass
    public static void setUpBeforeClass() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setUpBeforeClass");
        }
        pdm = ServiceLocator.getInstance().getPDMManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("*** pdm : " + pdm);
        }
        assertNotNull(pdm);
    }

    /**
     * Tests that the CRMManager crm instanciated in the setUp method
     * is not null.
     */
    @Test
    public void testGetPDM() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetPDM");
        }
        assertNotNull(pdm);
    }

    /**
     * Tests the PDMManager service method getAttributes
     * for a printer
     * @throws ApplicationException if an error occured that cannot be resolved in the business layer
     */
    @Test
    public void testGetAttributes() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetProducts");
        }
        List<AttributeValue> attributes = pdm.getAttributes("-55");
        assertEquals(0, attributes.size());
        attributes = pdm.getAttributes("-13");
        assertEquals(7, attributes.size());
        AttributeValue acousticPowerEmissions = attributes.get(0);
        assertEquals("6.5 B(A)", acousticPowerEmissions.getAttributeValueText());
        assertEquals("Acoustic Power Emissions", acousticPowerEmissions.getAttributeDefinition()
                .getAttributeDefinitionName());
        AttributeType type = acousticPowerEmissions.getAttributeDefinition().getAttributeType();
        assertEquals("free text", type.getAttributeTypeKey());
    }

    /**
     * Tests the PDMManager service method getBinaryForId
     * for a printer
     */
    @Test
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public void testGetBinariesForAttributeId() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetBinariesForAttributeId");
        }
        AttributeBinaryValue attrBinaryValue = pdm.getAttributeBinaryValueById("-900");
        assertNotNull(attrBinaryValue);

        attrBinaryValue = pdm.getAttributeBinaryValueById("-10");
        assertEquals(null, attrBinaryValue);
    }

}
