/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.service;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import javax.naming.NamingException;

/**
 * @author Claudius Haecker
 * Use <code>ServiceLocator.getInstance().getService(</code>beanName<code>)</code>
 * to get an instance of a service class.
 */
public final class ServiceLocator {
    private static final Logger LOG = Logger.getLogger(ServiceLocator.class);
    private static ServiceLocator self;

    /**
     * Application context, Spring container.
     */
    private static ApplicationContext ctxt;

    /**
     * ServiceLocator constructor.
     * creates a new ClassPathXmlApplicationContext
     */
    private ServiceLocator() {
        if (ServiceLocator.ctxt == null) {
            LOG.debug("\t=> ctxt is NULL!");
            ServiceLocator.ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        }
        /*
         * INFO:
         * org.springframework.context.support.ClassPathXmlApplicationContext
         * ClassPathXmlApplicationContext(String configLocation) Create a new
         * ClassPathXmlApplicationContext, loading the definitions from the
         * given XML file and automatically refreshing the context.
         */
    }

    /**
     * Gets the singleton instance of the this ServiceLocator
     * 
     * @return ServiceLocator singleton instance
     */
    public static ServiceLocator getInstance() {
        if (self == null) {
            self = new ServiceLocator();
        }
        return self;
    }

    /**
     * @param beanName bean name parameter
     * @return a service object depending on the given beanName parameter
     * @throws NamingException getBean method throws naming exception
     */
    private Object getService(final String beanName) throws NamingException {
        LOG.debug("=====> CALLED: getService()");
        Object obj = ServiceLocator.ctxt.getBean(beanName);
        if (obj == null) {
            throw new NamingException();
        }
        return obj;
    }

    /**
     * Locates an instance of {@link PDMManager}
     * in the Spring application context by its name.
     * @return instance of {@link PDMManager}
     */
    public PDMManager getPDMManager() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getPDMManager");
        }
        try {
            return (PDMManager) getService("pdmManager");
        } catch (NamingException e) {
            throw new Error("Could not get service pdmManager", e);
        }
    }

}
