/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.service;

import java.io.Serializable;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pdm_simulator.be.dao.AttributeDao;
import de.itemis.qimpress.showcase.pdm_simulator.be.dao.ProductDao;
import de.itemis.qimpress.showcase.pdm_simulator.be.dao.ProductGroupDao;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;

/**
 * @author Claudius Haecker
 *
 */
public class PDMManagerImpl implements Serializable, PDMManager {

    private static final long serialVersionUID = 7375457132325214031L;

    private static final Logger LOG = Logger.getLogger(PDMManagerImpl.class);

    ProductGroupDao productGroupDao;
    ProductDao productDao;
    AttributeDao attributeDao;

    /**
     * @param attributeDao the attributeDao to set
     */
    public void setAttributeDao(AttributeDao attributeDao) {
        this.attributeDao = attributeDao;
    }

    /**
     * @param productGroupDao the productGroupDao to set
     */
    public void setProductGroupDao(ProductGroupDao productGroupDao) {
        this.productGroupDao = productGroupDao;
    }

    /**
     * 
     * @param productDao the ProductDao to set
     */
    public void setProductDao(ProductDao productDao) {
        this.productDao = productDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager#getProductGroupRoot(boolean)
     */
    /** */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public ProductGroup getProductGroupRoot() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroupRoot");
        }
        ProductGroup productGroup = null;
        try {
            productGroup = productGroupDao.getProductGroupRoot();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        return productGroup;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager#getProductGroupByID(java.lang.String)
     */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public ProductGroup getProductGroupByID(String productGroupID) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroupByID - ID=" + productGroupID);
        }
        try {
            return productGroupDao.getProductGroupByID(productGroupID);
        } catch (DaoException e) {
            LOG.error("ERROR!");
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager#getProducts(java.lang.String)
     */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<Product> getProducts(String theProductGroupID) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProducts - product-group-ID=" + theProductGroupID);
        }
        try {
            return productDao.getProductsForProductGroup(theProductGroupID);
        } catch (DaoException e) {
            LOG.error("ERROR!");
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }
    
    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public Product getProductByCode(String productCode) throws ApplicationException {
        
    	Product product = null;
		long    start   = 0;
		long    stop    = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	try {
    		product = productDao.getProductByCode(productCode);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getProductByCode", start, stop);
        }
        
        return product;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.service.PDMManager#getProductAttributes(java.lang.String)
     */
    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeValue> getAttributes(String productId) throws ApplicationException {
        return attributeDao.getAttributes(productId);
    }

    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public AttributeBinaryValue getAttributeBinaryValueById(String attributeBinaryValueId) {
        return attributeDao.getAttributeBinaryValueById(attributeBinaryValueId);
    }

   /* @Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<ProductGroup> getProductGroups() throws DaoException {
        return productGroupDao.getProductGroups();
    }

    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<Product> getProducts() throws DaoException {
        return productDao.getProducts();
    }

    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeValue> getAttributeValues() throws DaoException {
        return attributeDao.getAttributeValues();
    }

    /*@Override*/
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeDefinition> getAttributeDefinitions() throws DaoException {
        return attributeDao.getAttributeDefinitions();
    }

}
