/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.exceptions;

/**
 * Exception wrapping exceptions (logical constraints and errors) of the
 * business layer.
 * @author Ina Jarocki
 */
public class ApplicationException extends Exception {
    /**
     * 
     */
    private static final long serialVersionUID = -5371962154818159701L;

    /**
     * Enumeration defining different error messages for different Exceptions
     * thrown on business layer.
     * @author Administrator
     */
    public enum ApplicationErrorCode {
        /**
         * Constant representing a technical error, thrown when exception is
         * thrown by a DAO.
         */
        TE("Technical_Error"),
        /**
         * Constant representing an error if input param is null.
         */
        RS_B_PARAM_NULL("input param is null");
        private String message;

        // Enumeration Constructor
        private ApplicationErrorCode(String message) {
            this.message = message;
        }
    }

    // Enumeration Object
    private ApplicationErrorCode errorCode;

    /**
     * Exception Constructor 1 - overwritten, sets errCode (enum object).
     */
    public ApplicationException(ApplicationErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Exception Constructor 2 - overwritten, sets errorCode (enum object) and
     * exception cause.
     * @param errorCode
     * @param cause Exception that threw the error
     */
    public ApplicationException(ApplicationErrorCode errorCode, Exception cause) {
        super(errorCode.message);
        this.errorCode = errorCode;
        this.initCause(cause);
    }

    /**
     * getter
     * 
     * @return error code
     */
    public ApplicationErrorCode getCode() {
        return errorCode;
    }

    /**
     * Returns specific error message, messages are defined in enumeration.
     * @return error message
     */
    public String getErrorMessage() {
        return errorCode.message;
    }
}
