/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.log4j.Logger;
import org.hibernate.annotations.IndexColumn;

/**
 * @author Claudius Haecker
 * corresponds to  dim_prod_hier
 */
@Entity
@Table(name = "product_group")
public class ProductGroup implements Serializable {

    private static final long serialVersionUID = -1749403837004115734L;

    private static final Logger LOG = Logger.getLogger(ProductGroup.class);

    private String productGroupId;
    private String productGroupCode;
    private String productGroupName;
    private String productGroupDescription;
    //    private String productGroupStatus;
    private ProductGroup parentProductGroup;
    private Collection<ProductGroup> childProductGroups;
    //    private List<Product> productList;
    private Set<Product> products;
    private int level;
    private Date dateLastModified;
    private Date dateCreated;

    // TODO: isRoot boolean

    //  private Date  LastModified;
    //  private Date  DateCreated;

    /**
     * @return
     * corresponds to  dim_prod_hier_id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "product_group_id")
    public String getProductGroupId() {
        return productGroupId;
    }

    public void setProductGroupId(String productGroupId) {
        this.productGroupId = productGroupId;
    }

    @Column(name = "product_group_code")
    public String getProductGroupCode() {
        return productGroupCode;
    }

    public void setProductGroupCode(String productGroupCode) {
        this.productGroupCode = productGroupCode;
    }

    @Column(name = "product_group_name")
    public String getProductGroupName() {
        return productGroupName;
    }

    public void setProductGroupName(String productGroupName) {
        this.productGroupName = productGroupName;
    }

    @Column(name = "product_group_description", length = 65535)
    public String getProductGroupDescription() {
        return productGroupDescription;
    }

    public void setProductGroupDescription(String productGroupDescription) {
        this.productGroupDescription = productGroupDescription;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_product_group_id", nullable = true)
    public ProductGroup getParentProductGroup() {
        return parentProductGroup;
    }

    public void setParentProductGroup(ProductGroup parentProductGroup) {
        this.parentProductGroup = parentProductGroup;
    }

    @OneToMany(mappedBy = "parentProductGroup", fetch = FetchType.LAZY)
    @IndexColumn(name = "product_group_id")
    public Collection<ProductGroup> getChildProductGroups() {
        return childProductGroups;
    }

    public void setChildProductGroups(Collection<ProductGroup> childProductGroups) {
        this.childProductGroups = childProductGroups;
    }

    @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "productGroup")
    @JoinColumn(name = "fk_product_group_id")
    //we need to duplicate the physical information
    public Set<Product> getProducts() {
        return products;
    }

    public void setProducts(Set<Product> products) {
        this.products = products;
    }

    /**
     * @return the level
     */
    @Column(name = "product_group_tree_depth")
    public int getLevel() {
        return level;
    }

    /**
     * @param level the level to set
     */
    public void setLevel(int level) {
        this.level = level;
    }


    /**
     * @return the dateCreated
     */
    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        this.dateLastModified = lastModified;
    }

    
    /**
     * verifies if the product group has child product groups.
     * @return true, if this <code>ProductGroup</code> has child product groups
     */
    @Transient
    public boolean getProductGroupHasChildren() {
        if (this.childProductGroups != null) {
            return this.childProductGroups.size() > 0;
        } else {
            return false;
        }
    }
    
    /**
     * Checks if this product group is a root product group 
     * (has no parent group)
     * 
     * @return true, if this product group is a root product group
     */
    @Transient
    public boolean isRootProductGroup() {
        return (parentProductGroup == null);
    }

}
