/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.apache.log4j.Logger;

@Entity
@Table(name = "product")
public class Product implements Serializable {

    private static final long serialVersionUID = -8652879210991470830L;

    private static final Logger LOG = Logger.getLogger(Product.class);

    private String productId;
    private String productCode;
    private String productName;
    private String productManufacturerKey;
    private ProductGroup productGroup;
    private List<AttributeValue> attributeValues;
    private Date dateCreated;
    private Date dateLastModified;

    public Product(String productId, String productCode, String productName, String productManufacturerKey,
            ProductGroup productGroup) {
        this.productId = productId;
        this.productCode = productCode;
        this.productName = productName;
        this.productManufacturerKey = productManufacturerKey;
        this.productGroup = productGroup;
    }

    public Product() {
    }

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "product_id")
    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * @return the dateCreated
     */
    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        this.dateLastModified = lastModified;
    }

    @Column(name = "product_code")
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @Column(name = "product_name")
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @ManyToOne
    @JoinColumn(name = "fk_product_group_id", insertable = false, updatable = false)
    public ProductGroup getProductGroup() {
        return productGroup;
    }

    public void setProductGroup(ProductGroup productGroup) {
        this.productGroup = productGroup;
    }

    /**
     * @return the productManufacturerKey
     */
    @Column(name = "product_manufacturer_key")
    public String getProductManufacturerKey() {
        return productManufacturerKey;
    }

    /**
     * @param productManufacturerKey the productManufacturerKey to set
     */
    public void setProductManufacturerKey(String productManufacturerKey) {
        this.productManufacturerKey = productManufacturerKey;
    }

    @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "product")
    @JoinColumn(name = "product_id")
    public List<AttributeValue> getAttributeValues() {
        return attributeValues;
    }

    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

}
