/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.log4j.Logger;

/**
 * @author Claudius Haecker
 *
 */

@Entity
@Table(name = "attribute_value")
public class AttributeValue {
    private static final Logger LOG = Logger.getLogger(AttributeValue.class);

    private String attributeValueText;
    private AttributeDefinition attributeDefinition;
    private Product product;
    private Date dateLastModified;
    private Date dateCreated;
    private String attributeValueId;
    private AttributeBinaryValue attributeBinaryValue;

    /**
     * @param attributeValueId the attributeValueId to set
     */
    public void setAttributeValueId(String attributeValueId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeValueId");
        }
        this.attributeValueId = attributeValueId;
    }

    /**
     * @return the attributeValueId
     */

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "attribute_value_id")
    public String getAttributeValueId() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributeValueId");
        }
        return attributeValueId;
    }

    /**
     * @return the attributeValueText
     */
    @Column(name = "attribute_value_text")
    public String getAttributeValueText() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributeValueText");
        }
        return attributeValueText;
    }

    /**
     * @param attributeValueText the attributeValueText to set
     */
    public void setAttributeValueText(String attributeValueText) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeValueText");
        }
        this.attributeValueText = attributeValueText;
    }

    /**
     * @return the attributeDefinition
     */

    @ManyToOne(optional = true, fetch = FetchType.EAGER)
    @JoinColumn(name = "attribute_definition_id")
    public AttributeDefinition getAttributeDefinition() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributeDefinition");
        }
        return attributeDefinition;
    }

    /**
     * @param attributeDefinition the attributeDefinition to set
     */
    public void setAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeDefinition");
        }
        this.attributeDefinition = attributeDefinition;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "product_id", insertable = false, updatable = false)
    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    /**
     * @return the attributeBinaryValue
     */
    @OneToOne(mappedBy = "attribute")
    public AttributeBinaryValue getAttributeBinaryValue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributeBinaryValue");
        }
        return attributeBinaryValue;
    }

    /**
     * @param attributeBinaryValue the attributeBinaryValue to set
     */
    public void setAttributeBinaryValue(AttributeBinaryValue attributeBinaryValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeBinaryValue");
        }
        this.attributeBinaryValue = attributeBinaryValue;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getLastModified");
        }
        return dateLastModified;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setLastModified");
        }
        this.dateLastModified = lastModified;
    }

    /**
     * @return the dateCreated
     */
    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getDateCreated");
        }
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setDateCreated");
        }
        this.dateCreated = dateCreated;
    }
    
    /**
     * Checks, if this attribute has binary value
     * 
     * @return true, if this attribute stores binary value
     */
    @Transient
    public boolean isBinaryValued() {
        return (this.getAttributeBinaryValue() != null);
    }
}
