/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.log4j.Logger;

/**
 * @author Claudius Haecker
 * 
 */

@Entity
@Table(name = "attribute_type")
public class AttributeType {
    private static final Logger LOG = Logger.getLogger(AttributeType.class);

    private String attributeTypeId;
    private String attributeTypeKey;
    /**
     * @param attributeTypeKey the attributeTypeKey to set
     */
    public void setAttributeTypeKey(String attributeTypeKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeTypeKey");
        }
        this.attributeTypeKey = attributeTypeKey;
    }

    private Date dateCreated;
    private Date dateLastModified;

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "attribute_type_id")
    public String getAttributeTypeId() {
        return attributeTypeId;
    }

    @Column(name = "attribute_type_key")
    public String getAttributeTypeKey() {
        return attributeTypeKey;
    }

    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param attributeTypeId the attributeTypeId to set
     */
    public void setAttributeTypeId(String attributeTypeId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeTypeId");
        }
        this.attributeTypeId = attributeTypeId;
    }



    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setDateCreated");
        }
        this.dateCreated = dateCreated;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setLastModified");
        }
        this.dateLastModified = lastModified;
    }
    
    private enum TypeName {
        StringType("free text"), IntegerType("integer"), BinaryType("binary");
        
        private String typeName;
        
        TypeName(String typeName) {
            this.typeName = typeName;
        }
        
        public boolean isEqualType(String otherTypeName) {
            return typeName.equals(otherTypeName);
        }
    }

}
