/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.apache.log4j.Logger;

/**
 * @author Claudius Haecker
 *
 */
@Entity
@Table(name = "attribute_definition")
public class AttributeDefinition {
    private static final Logger LOG = Logger.getLogger(AttributeDefinition.class);
    private String attributeDefinitionDescription;
    private String attributeDefinitionId;
    private String attributeDefinitionCode;
    private String attributeDefinitionName;
    private AttributeType attributeType;
    private Date dateCreated;
    private Date dateLastModified;

    @Column(name = "attribute_definition_description")
    public String getAttributeDefinitionDescription() {
        return attributeDefinitionDescription;
    }
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "attribute_definition_id")
    public String getAttributeDefinitionId() {
        return attributeDefinitionId;
    }

    @Column(name = "attribute_definition_code")
    public String getAttributeDefinitionCode() {
        return attributeDefinitionCode;
    }
    
    @Column(name = "attribute_definition_name")
    public String getAttributeDefinitionName() {
        return attributeDefinitionName;
    }
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "attribute_type_id")
    public AttributeType getAttributeType() {
        return attributeType;
    }

    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        return dateLastModified;
    }

    /**
     * @param attributeDefinitionDescription the attributeDefinitionDescription to set
     */
    public void setAttributeDefinitionDescription(String attributeDefinitionDescription) {
        this.attributeDefinitionDescription = attributeDefinitionDescription;
    }

    /**
     * @param attributeDefinitionId the attributeDefinitionId to set
     */
    public void setAttributeDefinitionId(String attributeDefinitionId) {
        this.attributeDefinitionId = attributeDefinitionId;
    }

    public void setAttributeDefinitionCode(String attributeDefinitionCode) {
        this.attributeDefinitionCode = attributeDefinitionCode;
    }

    /**
     * @param attributeDefinitionName the attributeDefinitionName to set
     */
    public void setAttributeDefinitionName(String attributeDefinitionName) {
        this.attributeDefinitionName = attributeDefinitionName;
    }

    /**
     * @param attributeType the attributeType to set
     */
    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        this.dateLastModified = lastModified;
    }

}
