/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.domain;

import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.apache.log4j.Logger;

/**
 * @author Claudius Haecker
 *
 */
@Entity
@Table(name = "attribute_binary_value")
public class AttributeBinaryValue {
    private static final Logger LOG = Logger.getLogger(AttributeBinaryValue.class);
    private String attributeBinaryValueId;
    private byte[] binaryData;
    private String processingInformation;
    private String fileName;
    private String mimeType;
    private Date dateLastModified;
    private Date dateCreated;
    private AttributeValue attribute;

    /**
     * This data is processed depending on the type of the Data.
     * It can contain things like mime type or a foreign key pointing to other attributes. 
     * @return the processing information
     */
    @Column(name = "processing_information", length = 1023)
    public String getProcessingInformation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProcessingInformation");
        }
        return processingInformation;
    }

    /**
     * @param processingInformation the processingInformation to set
     */
    public void setProcessingInformation(String processingInformation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setProcessingInformation");
        }
        this.processingInformation = processingInformation;
    }

    /**
     * @return the fileName
     */
    @Column(name = "file_name")
    public String getFileName() {
        return fileName;
    }

    /**
     * @param fileName the fileName to set
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * @return the mimeType
     */
    @Column(name = "mime_type")
    public String getMimeType() {
        return mimeType;
    }

    /**
     * @param mimeType the mimeType to set
     */
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    /**
     * @return the attributeBinaryValueId
     */
    @Id
    //@GeneratedValue(strategy = GenerationType.SEQUENCE)
    @Column(name = "attribute_binary_value_id")
    public String getAttributeBinaryValueId() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributeBinaryValueId");
        }
        return attributeBinaryValueId;
    }

    /**
     * @param attributeBinaryValueId the attributeBinaryValueId to set
     */
    public void setAttributeBinaryValueId(String attributeBinaryValueId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setAttributeBinaryValueId");
        }
        this.attributeBinaryValueId = attributeBinaryValueId;
    }


    /**
     * @param binaryData the binaryData to set
     */
    public void setBinaryData(byte[] binaryData) {
        if (LOG.isDebugEnabled()) {
        	LOG.debug(">> setBinaryData");
        }
        this.binaryData = binaryData;
    }

    /**
     * @return the binaryData
     */
    @Lob 
    @Basic(fetch=FetchType.LAZY)
    @Column(name = "binary_data")
    public byte[] getBinaryData() {
        if (LOG.isDebugEnabled()) {
        	LOG.debug(">> getBinaryData");
        }
        return binaryData;
    }

    /**
     * @return the attribute
     */
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="attribute_value_id", nullable=false, updatable=false)
    public AttributeValue getAttribute() {
        return attribute;
    }

    /**
     * @param attribute the attribute to set
     */
    public void setAttribute(AttributeValue attribute) {
        this.attribute = attribute;
    }

    /**
     * @return the dateCreated
     */
    /**
    * returns the date set by the database on each row when <code>this</code> was inserted into the database.
    * @return the creation date
    */
    @Column(name = "date_created", nullable = false, insertable = false, updatable = false)
    public Date getDateCreated() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getDateCreated");
        }
        return dateCreated;
    }

    /**
     * @param dateCreated the dateCreated to set
     */
    public void setDateCreated(Date dateCreated) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setDateCreated");
        }
        this.dateCreated = dateCreated;
    }

    /**
    * returns the date (as set by the database) when <code>this</code> was updated in the database the last time.
    * @return the creation date
    */
    @Column(name = "last_modified", nullable = false, insertable = false, updatable = false)
    public Date getDateLastModified() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getLastModified");
        }
        return dateLastModified;
    }

    /**
     * @param lastModified the dateLastModified to set
     */
    public void setDateLastModified(Date lastModified) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setLastModified");
        }
        this.dateLastModified = lastModified;
    }

}
