/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;

/**
 * @author Claudius Haecker
 * 
 */
public class ProductGroupDaoImpl extends HibernateDaoSupport implements ProductGroupDao, Serializable {

    private static final long serialVersionUID = 7540566923640255052L;
    private static final Logger LOG = Logger.getLogger(ProductGroupDaoImpl.class);

    /*
     * (non-Javadoc)
     * 
     * @seede.itemis.qimpress.showcase.pdm_simulator.be.dao.ProductGroupDao#
     * getProductGroupRoot()
     */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public ProductGroup getProductGroupRoot() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroupRoot");
        }

        String queryString = "Select pg FROM ProductGroup pg " + "WHERE pg.parentProductGroup = null";
        // TODO: delete LOGs
        try {
            List<ProductGroup> pgList = getHibernateTemplate().find(queryString);
            if (LOG.isDebugEnabled()) {
                if (pgList != null) {
                    LOG.debug("\t*** => productGroups-SIZE = " + pgList.size());
                }
            }
            if (pgList != null && pgList.size() > 0) {
                ProductGroup rootProductGroup = pgList.get(0);
                traverseTree(rootProductGroup);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("\t*** => root-name = " + rootProductGroup.getProductGroupName());
                }
                return rootProductGroup;
            } else {
                LOG.error("ERROR no root element found!");
                return null;
            }
        } catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new DaoException();
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.dao.ProductGroupDao#getProductGroupByID(java.lang.String)
     */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public ProductGroup getProductGroupByID(String productGroupID) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroupByID");
        }
        try {
            ProductGroup productGroup = (ProductGroup) getHibernateTemplate().get(ProductGroup.class, productGroupID);
            traverseTree(productGroup);
            return productGroup;
        } catch (DataAccessException e) {
            LOG.error("ERROR - getProductGroupByID");
            e.printStackTrace();
            throw new DaoException(e);
        }
    }

    /*@Override*/
    public List<ProductGroup> getProductGroups() throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductGroups");
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ProductGroup.class);
        criteria.setFetchMode("parentProductGroup", FetchMode.JOIN);
        List<ProductGroup> productGroups = getHibernateTemplate().findByCriteria(criteria);
        return productGroups;
    }

    /**
     * Traverses the product group tree starting from the given product group.
     * Allows to trigger lazy loading and to populate the corresponding 
     * product group children collections.
     * 
     * @param productGroup
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup}
     * ProductGroup to start traversing from
     */
    private void traverseTree(ProductGroup productGroup) {
        if (productGroup == null) {
            return;
        }
        for (ProductGroup child : productGroup.getChildProductGroups()) {
            traverseTree(child);
        }
        productGroup.getParentProductGroup();
    }

}
