/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;

/**
 * @author Claudius Haecker
 */
public interface ProductGroupDao {


    /**
     * Gets the root product group.
     * @return root {@link ProductGroup}
     */
    public ProductGroup getProductGroupRoot() throws DaoException;



    /**
     * Gets a product group by the given productGroupID parameter.
     * @param productGroupID
     * @return {@link ProductGroup} for the given productGroupID or <code>null</code>, if not found
     * @throws DaoException if data access results in an error
     */
    public ProductGroup getProductGroupByID (String productGroupID)
            throws DaoException;

    
    
    /**
     * Loads all stored
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup ProductGroups}
     * from the database.
     * 
     * @return list of all stored
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup ProductGroups}
     * @throws DaoException if data access results in an error
     */
    public List<ProductGroup> getProductGroups() throws DaoException;

}

