/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.common.Meassurements;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.ProductGroup;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class ProductDaoImpl extends HibernateDaoSupport implements ProductDao {

    private static final Logger LOG = Logger.getLogger(ProductDaoImpl.class);
    
    private ProductGroupDao productGroupDao;
    
    /**
     * @param productGroupDao the productGroupDao to set
     */
    public void setProductGroupDao(ProductGroupDao productGroupDao) {
        this.productGroupDao = productGroupDao;
    }


    /* @Override */
    public List<Product> getProducts() {
        return getHibernateTemplate().find("from Product");
    }
    
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.dao.ProductGroupDao#getProducts(java.lang.String)
     */
    public List<Product> getProductsForProductGroup(String theProductGroupID) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductsForProductGroup");
        }
        ProductGroup baseProductGroup = productGroupDao.getProductGroupByID(theProductGroupID);
        if (LOG.isDebugEnabled() && baseProductGroup != null) {
            LOG.debug("\t***DAO*** - baseProductGroup-NAME = " + baseProductGroup.getProductGroupName());
        }

        List<Product> productList = new ArrayList<Product>();
        productList = getProductsRecursive(new ArrayList<Product>(), baseProductGroup);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\t***DAO*** - productList-SIZE = " + productList.size());
        }
        return productList;
    }

    /**
     * Gets all products for all product groups under the tree for the
     * given product group.
     * @param productList 
     * @return a list with all products
     */
    private List<Product> getProductsRecursive(List<Product> productList, ProductGroup productGroup)
            throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("*** getProductsRecursive ***");
        }
        if (productGroup != null) {
            productList.addAll(getProductsByProductGroupIdFromDB(productGroup.getProductGroupId()));
            for (ProductGroup pg : productGroup.getChildProductGroups()) {

                if (LOG.isDebugEnabled()) {
                    LOG.debug("\t\t*** productGroup-NAME = " + pg.getProductGroupName());
                }
                getProductsRecursive(productList, pg);
            }
        }
        return productList;
    }

    /**
     * Gets the products for the product group by the given id from database.
     * @param theID
     * @return
     * @throws DaoException if data access results in an error
     */
    private List<Product> getProductsByProductGroupIdFromDB(String theID) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getProductsByProductGroupIdFromDB - ID = " + theID);
        }
        String queryString = "SELECT p FROM Product p WHERE p.productGroup = '" + theID + "'";
        try {
            return getHibernateTemplate().find(queryString);
        } catch (DataAccessException e) {
            LOG.error("ERROR - DataAccessException calling " + "getProductsByProductGroupIdFromDB");
            throw new DaoException();
        }
    }
    

   /* @Override*/
    public Product getProductByCode(String productCode) throws DaoException {
        
		long    start   = 0;
		long    stop    = 0;

    	if (LOG.isTraceEnabled()) {
    		start = System.currentTimeMillis();
    	}
    	
    	List<Product> productList = null;
    	Product       product     = null;
    	
        try {
            DetachedCriteria criteria = DetachedCriteria.forClass(Product.class);
            criteria.add(Restrictions.eq("productCode", productCode));
            criteria.setFetchMode("attributeValues", FetchMode.JOIN);
            // special transformer required to avoid duplicates in the result list (caused by OneToMany fetch)
            criteria.setResultTransformer(DetachedCriteria.DISTINCT_ROOT_ENTITY);
            productList = getHibernateTemplate().findByCriteria(criteria);
            if (productList == null) {
                LOG.error("Unexpected Product search result: null");
                throw new DaoException();
            }
            if (productList.size() > 1) {
                LOG.error("Unexpected Product search result: found more than 1 element");
                throw new DaoException();
            }
        } catch (DataAccessException e) {
            LOG.error("Failed to get Product by Code", e);
            throw new DaoException();
        }
        if (productList.size() == 1) {
            product = productList.get(0);
        }
        
        if (LOG.isTraceEnabled()) {
        	stop = System.currentTimeMillis();
        	Meassurements.add(this.getClass().getSimpleName(), "getProductByCode", start, stop);
        }
        
        return product;
    }
}
