/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.pdm_simulator.be.exceptions.DaoException;

/**
 * DAO interface for loading and storing objects of the
 * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product} class.
 * 
 * @author Wladimir Safonov
 *
 */
public interface ProductDao {

    /**
     * Loads all stored products in a list for bulk processing.
     * 
     * @return a list of all stored products
     */
    public List<Product> getProducts();
    

    /**
     * Gets a list with all products for the product group (for the given ID)
     * in this product group tree.
     * 
     * @param theProductGroupID
     * @return the product list for the given product group
     * @throws ApplicationException if an error occured that cannot be resolved in the business layer
     */
    public List<Product> getProductsForProductGroup(String theProductGroupID) throws DaoException;

    /**
     * Loads a {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product} and its corresponding parent
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product#getProductGroup() product group} 
     * by the {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product#getProductCode() product code}.
     * 
     * @param productCode product
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product#getProductCode() code}
     * to look a product for
     * @return 
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.Product}
     * with the given product code or null, if not found.
     * @throws DaoException if data access results in an error
     */
    public Product getProductByCode(String productCode) throws DaoException;
}
