/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;

/**
 * @author Claudius Haecker
 *
 */
public class AttributeDaoImpl extends HibernateDaoSupport implements Serializable, AttributeDao {
    private static final long serialVersionUID = -1131932208158868200L;
    private static final Logger LOG = Logger.getLogger(AttributeDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.dao.AttributeDao#getAttributes(java.lang.String)
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeValue> getAttributes(String productId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getAttributes");
        }
        
        DetachedCriteria criteria = DetachedCriteria.forClass(AttributeValue.class);
        criteria.add(Restrictions.eq("product.productId", productId));
        List<AttributeValue> attributes = this.getHibernateTemplate().findByCriteria(criteria);

        return attributes;
    }

    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeValue> getAttributeValues() {
        DetachedCriteria criteria = DetachedCriteria.forClass(AttributeValue.class);
        criteria.setFetchMode("product", FetchMode.JOIN);
        return getHibernateTemplate().findByCriteria(criteria);
    }

    /*  @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public List<AttributeDefinition> getAttributeDefinitions() {
        return getHibernateTemplate().find("from AttributeDefinition");
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.pdm_simulator.be.dao.AttributeDao#getBinaryForId(java.lang.String)
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public AttributeBinaryValue getAttributeBinaryValueById(String attributeBinaryValueId) {
        
        List list = this.getHibernateTemplate().find("from AttributeBinaryValue fetch all properties where attributeBinaryValueId = '" +
                attributeBinaryValueId + "'");
        
        if (list.size() != 1) {
            return null;
        }
        
        return (AttributeBinaryValue) list.get(0);
    }

}
