/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.pdm_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition;
import de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue;

/**
 * @author Claudius Haecker
 *
 */
public interface AttributeDao {
    /**
     * Returns a list of AttributeValue-Objects.
     * These provide access to
     *  {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition}
     * which in turn provide access to
     *  {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeType}.
     * @param productId The productId to search for
     * @return a list of AttributeValue-Objects.
     */
    public List<AttributeValue> getAttributes(String productId);

    /**
     * Loads {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue} for given ID
     * eagerly fetching binary data.
     * 
     * @param attributeBinaryValueId binary attribute value ID
     * @return {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeBinaryValue} with loaded binary data
     */
    public AttributeBinaryValue getAttributeBinaryValueById(String attributeBinaryValueId);

    /**
     * Loads all stored 
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue AttributeValues}
     * from the database. The corresponding owning 
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue#getProduct() products}
     * are loaded as well.
     * 
     * @return list of all stored
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeValue AttributeValues}
     */
    public List<AttributeValue> getAttributeValues();
    
    /**
     * Loads all stored 
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition AttributeDefinitions}
     * from the database.
     * 
     * @return list of all stored
     * {@link de.itemis.qimpress.showcase.pdm_simulator.be.domain.AttributeDefinition AttributeDefinitions}
     */
    public List<AttributeDefinition> getAttributeDefinitions();

}
