--
-- PostgreSQL database dump
--

-- Started on 2008-12-01 13:46:18

DROP PROCEDURAL LANGUAGE IF EXISTS plpgsql; 
CREATE PROCEDURAL LANGUAGE plpgsql;

--
-- TOC entry 18 (class 1255 OID 157972)
-- Dependencies: 276 5
-- Name: update_created_column(); Type: FUNCTION; Schema: public; Owner: pdm_user
--

CREATE FUNCTION update_created_column() RETURNS "trigger"
    AS 'BEGIN NEW.date_created = now(); RETURN NEW;	END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_created_column() OWNER TO pdm_user;

--
-- TOC entry 1653 (class 0 OID 0)
-- Dependencies: 18
-- Name: FUNCTION update_created_column(); Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON FUNCTION update_created_column() IS 'Sets date_created to the current date. Should be triggered on  Inserts.';


--
-- TOC entry 19 (class 1255 OID 157973)
-- Dependencies: 5 276
-- Name: update_modified_column(); Type: FUNCTION; Schema: public; Owner: pdm_user
--

CREATE FUNCTION update_modified_column() RETURNS "trigger"
    AS 'BEGIN NEW.last_modified = now(); RETURN NEW; END;'
    LANGUAGE plpgsql;


ALTER FUNCTION public.update_modified_column() OWNER TO pdm_user;

--
-- TOC entry 1654 (class 0 OID 0)
-- Dependencies: 19
-- Name: FUNCTION update_modified_column(); Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON FUNCTION update_modified_column() IS 'Sets last_modified to the current date. Should be triggered on Updates.';


--
-- TOC entry 1281 (class 1259 OID 189813)
-- Dependencies: 5
-- Name: attribute_binary_value; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE attribute_binary_value (
    attribute_binary_value_id character varying(255) NOT NULL,
    file_name character varying(255),
    mime_type character varying(255),
    binary_data oid,
    processing_information character varying(1023),
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    attribute_value_id character varying(255) NOT NULL
);


ALTER TABLE public.attribute_binary_value OWNER TO pdm_user;

--
-- TOC entry 1282 (class 1259 OID 189820)
-- Dependencies: 5
-- Name: attribute_definition; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE attribute_definition (
    attribute_definition_id character varying(255) NOT NULL,
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    attribute_definition_description character varying(255),
    attribute_definition_code character varying(255),
    attribute_definition_name character varying(255),
    attribute_type_id character varying(255)
);


ALTER TABLE public.attribute_definition OWNER TO pdm_user;

--
-- TOC entry 1283 (class 1259 OID 189827)
-- Dependencies: 5
-- Name: attribute_type; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE attribute_type (
    attribute_type_id character varying(255) NOT NULL,
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    attribute_type_key character varying(255)
);


ALTER TABLE public.attribute_type OWNER TO pdm_user;

--
-- TOC entry 1284 (class 1259 OID 189834)
-- Dependencies: 5
-- Name: attribute_value; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE attribute_value (
    attribute_value_id character varying(255) NOT NULL,
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    attribute_value_text character varying(255),
    product_id character varying(255),
    attribute_definition_id character varying(255)
);


ALTER TABLE public.attribute_value OWNER TO pdm_user;

--
-- TOC entry 1287 (class 1259 OID 189885)
-- Dependencies: 5
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: pdm_user
--

CREATE SEQUENCE hibernate_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.hibernate_sequence OWNER TO pdm_user;

--
-- TOC entry 1285 (class 1259 OID 189841)
-- Dependencies: 5
-- Name: product; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE product (
    product_id character varying(255) NOT NULL,
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    product_code character varying(255),
    product_name character varying(255),
    product_manufacturer_key character varying(255),
    fk_product_group_id character varying(255)
);


ALTER TABLE public.product OWNER TO pdm_user;

--
-- TOC entry 1286 (class 1259 OID 189848)
-- Dependencies: 5
-- Name: product_group; Type: TABLE; Schema: public; Owner: pdm_user; Tablespace: 
--

CREATE TABLE product_group (
    product_group_id character varying(255) NOT NULL,
    product_group_tree_depth integer,
    product_group_code character varying(255),
    product_group_name character varying(255),
    product_group_description character varying(65535),
    date_created timestamp without time zone NOT NULL,
    last_modified timestamp without time zone NOT NULL,
    parent_product_group_id character varying(255)
);


ALTER TABLE public.product_group OWNER TO pdm_user;

--
-- TOC entry 1619 (class 2606 OID 189819)
-- Dependencies: 1281 1281
-- Name: attribute_binary_value_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY attribute_binary_value
    ADD CONSTRAINT attribute_binary_value_pkey PRIMARY KEY (attribute_binary_value_id);


--
-- TOC entry 1621 (class 2606 OID 189826)
-- Dependencies: 1282 1282
-- Name: attribute_definition_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY attribute_definition
    ADD CONSTRAINT attribute_definition_pkey PRIMARY KEY (attribute_definition_id);


--
-- TOC entry 1623 (class 2606 OID 189833)
-- Dependencies: 1283 1283
-- Name: attribute_type_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY attribute_type
    ADD CONSTRAINT attribute_type_pkey PRIMARY KEY (attribute_type_id);


--
-- TOC entry 1625 (class 2606 OID 189840)
-- Dependencies: 1284 1284
-- Name: attribute_value_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY attribute_value
    ADD CONSTRAINT attribute_value_pkey PRIMARY KEY (attribute_value_id);


--
-- TOC entry 1629 (class 2606 OID 189854)
-- Dependencies: 1286 1286
-- Name: product_group_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY product_group
    ADD CONSTRAINT product_group_pkey PRIMARY KEY (product_group_id);


--
-- TOC entry 1627 (class 2606 OID 189847)
-- Dependencies: 1285 1285
-- Name: product_pkey; Type: CONSTRAINT; Schema: public; Owner: pdm_user; Tablespace: 
--

ALTER TABLE ONLY product
    ADD CONSTRAINT product_pkey PRIMARY KEY (product_id);


--
-- TOC entry 1636 (class 2620 OID 197430)
-- Dependencies: 18 1281
-- Name: trigger_created_attribute_binary_value; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_attribute_binary_value
    BEFORE INSERT ON attribute_binary_value
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1655 (class 0 OID 0)
-- Dependencies: 1636
-- Name: TRIGGER trigger_created_attribute_binary_value ON attribute_binary_value; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_attribute_binary_value ON attribute_binary_value IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1638 (class 2620 OID 197432)
-- Dependencies: 1282 18
-- Name: trigger_created_attribute_definition; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_attribute_definition
    BEFORE INSERT ON attribute_definition
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1656 (class 0 OID 0)
-- Dependencies: 1638
-- Name: TRIGGER trigger_created_attribute_definition ON attribute_definition; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_attribute_definition ON attribute_definition IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1640 (class 2620 OID 197434)
-- Dependencies: 18 1283
-- Name: trigger_created_attribute_type; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_attribute_type
    BEFORE INSERT ON attribute_type
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1657 (class 0 OID 0)
-- Dependencies: 1640
-- Name: TRIGGER trigger_created_attribute_type ON attribute_type; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_attribute_type ON attribute_type IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1642 (class 2620 OID 197436)
-- Dependencies: 18 1284
-- Name: trigger_created_attribute_value; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_attribute_value
    BEFORE INSERT ON attribute_value
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1658 (class 0 OID 0)
-- Dependencies: 1642
-- Name: TRIGGER trigger_created_attribute_value ON attribute_value; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_attribute_value ON attribute_value IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1644 (class 2620 OID 197438)
-- Dependencies: 18 1285
-- Name: trigger_created_product; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_product
    BEFORE INSERT ON product
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1659 (class 0 OID 0)
-- Dependencies: 1644
-- Name: TRIGGER trigger_created_product ON product; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_product ON product IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1646 (class 2620 OID 197440)
-- Dependencies: 1286 18
-- Name: trigger_created_product_group; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_created_product_group
    BEFORE INSERT ON product_group
    FOR EACH ROW
    EXECUTE PROCEDURE update_created_column();


--
-- TOC entry 1660 (class 0 OID 0)
-- Dependencies: 1646
-- Name: TRIGGER trigger_created_product_group ON product_group; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_created_product_group ON product_group IS 'fires when a row is inserted to call a function which updates the date_created field';


--
-- TOC entry 1637 (class 2620 OID 197431)
-- Dependencies: 1281 19
-- Name: trigger_modified_attribute_binary_value; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_attribute_binary_value
    BEFORE INSERT OR UPDATE ON attribute_binary_value
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1661 (class 0 OID 0)
-- Dependencies: 1637
-- Name: TRIGGER trigger_modified_attribute_binary_value ON attribute_binary_value; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_attribute_binary_value ON attribute_binary_value IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1639 (class 2620 OID 197433)
-- Dependencies: 19 1282
-- Name: trigger_modified_attribute_definition; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_attribute_definition
    BEFORE INSERT OR UPDATE ON attribute_definition
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1662 (class 0 OID 0)
-- Dependencies: 1639
-- Name: TRIGGER trigger_modified_attribute_definition ON attribute_definition; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_attribute_definition ON attribute_definition IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1641 (class 2620 OID 197435)
-- Dependencies: 19 1283
-- Name: trigger_modified_attribute_type; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_attribute_type
    BEFORE INSERT OR UPDATE ON attribute_type
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1663 (class 0 OID 0)
-- Dependencies: 1641
-- Name: TRIGGER trigger_modified_attribute_type ON attribute_type; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_attribute_type ON attribute_type IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1643 (class 2620 OID 197437)
-- Dependencies: 19 1284
-- Name: trigger_modified_attribute_value; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_attribute_value
    BEFORE INSERT OR UPDATE ON attribute_value
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1664 (class 0 OID 0)
-- Dependencies: 1643
-- Name: TRIGGER trigger_modified_attribute_value ON attribute_value; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_attribute_value ON attribute_value IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1645 (class 2620 OID 197439)
-- Dependencies: 19 1285
-- Name: trigger_modified_product; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_product
    BEFORE INSERT OR UPDATE ON product
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1665 (class 0 OID 0)
-- Dependencies: 1645
-- Name: TRIGGER trigger_modified_product ON product; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_product ON product IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1647 (class 2620 OID 197441)
-- Dependencies: 1286 19
-- Name: trigger_modified_product_group; Type: TRIGGER; Schema: public; Owner: pdm_user
--

CREATE TRIGGER trigger_modified_product_group
    BEFORE INSERT OR UPDATE ON product_group
    FOR EACH ROW
    EXECUTE PROCEDURE update_modified_column();


--
-- TOC entry 1666 (class 0 OID 0)
-- Dependencies: 1647
-- Name: TRIGGER trigger_modified_product_group ON product_group; Type: COMMENT; Schema: public; Owner: pdm_user
--

COMMENT ON TRIGGER trigger_modified_product_group ON product_group IS 'fires when a row is updated to call a function which updates the last_modified field';


--
-- TOC entry 1631 (class 2606 OID 189860)
-- Dependencies: 1282 1283 1622
-- Name: fk395266d6fe7aa956; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY attribute_definition
    ADD CONSTRAINT fk395266d6fe7aa956 FOREIGN KEY (attribute_type_id) REFERENCES attribute_type(attribute_type_id);


--
-- TOC entry 1630 (class 2606 OID 189855)
-- Dependencies: 1284 1281 1624
-- Name: fk3d6f1876a52931be; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY attribute_binary_value
    ADD CONSTRAINT fk3d6f1876a52931be FOREIGN KEY (attribute_value_id) REFERENCES attribute_value(attribute_value_id);


--
-- TOC entry 1635 (class 2606 OID 189880)
-- Dependencies: 1628 1286 1286
-- Name: fk51f3772feca499cd; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY product_group
    ADD CONSTRAINT fk51f3772feca499cd FOREIGN KEY (parent_product_group_id) REFERENCES product_group(product_group_id);


--
-- TOC entry 1633 (class 2606 OID 189870)
-- Dependencies: 1284 1285 1626
-- Name: fkd7f53a0e3bcb395d; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY attribute_value
    ADD CONSTRAINT fkd7f53a0e3bcb395d FOREIGN KEY (product_id) REFERENCES product(product_id);


--
-- TOC entry 1632 (class 2606 OID 189865)
-- Dependencies: 1620 1284 1282
-- Name: fkd7f53a0e600871b6; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY attribute_value
    ADD CONSTRAINT fkd7f53a0e600871b6 FOREIGN KEY (attribute_definition_id) REFERENCES attribute_definition(attribute_definition_id);


--
-- TOC entry 1634 (class 2606 OID 189875)
-- Dependencies: 1286 1285 1628
-- Name: fked8dccef28daef12; Type: FK CONSTRAINT; Schema: public; Owner: pdm_user
--

ALTER TABLE ONLY product
    ADD CONSTRAINT fked8dccef28daef12 FOREIGN KEY (fk_product_group_id) REFERENCES product_group(product_group_id);


--
-- TOC entry 1652 (class 0 OID 0)
-- Dependencies: 5
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2008-12-01 13:46:18

--
-- PostgreSQL database dump complete
--

