/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.webservice.mock;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint;


/**
 * @author Wladimir Safonov
 *
 */
public class MockOrderSimulatorJDomEndpoint extends AbstractJDomPayloadEndpoint {

    private static final Logger LOG = Logger.getLogger(MockOrderSimulatorJDomEndpoint.class);
    
    private static final String START_ORDER_SIMULATOR_REQUEST = "StartOrderSimulatorRequest";
    private static final String START_ORDER_SIMULATOR_RESPONSE = "StartOrderSimulatorResponse";
    private static final String STOP_ORDER_SIMULATOR_REQUEST = "StopOrderSimulatorRequest";
    private static final String STOP_ORDER_SIMULATOR_RESPONSE = "StopOrderSimulatorResponse";
    private static final String GET_ORDER_SIMULATOR_STATUS_REQUEST = "GetOrderSimulatorStatusRequest";
    private static final String GET_ORDER_SIMULATOR_STATUS_RESPONSE = "GetOrderSimulatorStatusResponse";
    
    private static final String STATUS_RUNNING = "RUNNING";
    private static final String STATUS_STOPPED = "STOPPED";
    
    private Namespace namespace;
    
    private boolean isSimulatorRunning = false;
    
    public MockOrderSimulatorJDomEndpoint() {
        super();
        namespace = Namespace.getNamespace("os", "http://www.itemis.com/order_simulator/schemas");
    }

    @Override
    protected Element invokeInternal(Element request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> invokeInternal()");
        }
        
        String rootElement = request.getName();
        if (START_ORDER_SIMULATOR_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + START_ORDER_SIMULATOR_REQUEST);
            }
            
            return processStartOrderSimulatorRequest(request);
        } else if (STOP_ORDER_SIMULATOR_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + STOP_ORDER_SIMULATOR_REQUEST);
            }
            
            return processStopOrderSimulatorRequest(request);
        } else if (GET_ORDER_SIMULATOR_STATUS_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + GET_ORDER_SIMULATOR_STATUS_REQUEST);
            }
            
            return processGetOrderSimulatorStatusRequest(request);
        } 
        return null;
    }
    
    protected Element processStartOrderSimulatorRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processStartOrderSimulatorRequest()");
        }
        
        // start order generator
        isSimulatorRunning = true;
        
        // create response element
        Element response = new Element(START_ORDER_SIMULATOR_RESPONSE, namespace);
        Element result = new Element("StartResult", namespace).setText(Boolean.toString(isSimulatorRunning));
        response.addContent(result);
        
        return response;
    }
    
    protected Element processStopOrderSimulatorRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processStopOrderSimulatorRequest()");
        }

        // stop order generator
        isSimulatorRunning = false;
        
        // create response element
        Element response = new Element(STOP_ORDER_SIMULATOR_RESPONSE, namespace);
        Element result = new Element("StopResult", namespace).setText(Boolean.toString(isSimulatorRunning));
        response.addContent(result);
        
        return response;
    }
    
    protected Element processGetOrderSimulatorStatusRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processGetOrderSimulatorStatusRequest()");
        }
        
        // create response element
        Element response = new Element(GET_ORDER_SIMULATOR_STATUS_RESPONSE, namespace);
        Element result = new Element("StatusResult", namespace).setText(isSimulatorRunning ? STATUS_RUNNING : STATUS_STOPPED);
        response.addContent(result);
        
        return response;
    }
    
}
