/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.jsf.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.event.ActionEvent;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager;
import de.itemis.qimpress.showcase.order_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.CustomerTypeParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;

/**
 * The OrderSimulatorFeController class controls communication between
 * frontend and backend.
 * @author Claudius Haecker
 */
public class OrderSimulatorFeController implements Serializable {

    private static final long serialVersionUID = 3411175624659037944L;
    private static final Logger LOG = Logger.getLogger(OrderSimulatorFeController.class);
    private OrderSimulatorManager osgAppManager = ServiceLocator.getInstance().getOrderSimulatorManager();
    private boolean actionWasSuccess;
    private GlobalParameters globalParameters;
    private ArrayList<Action> actionHistory = new ArrayList<Action>();

    /**
     * @return the actionHistory
     */
    public ArrayList<Action> getActionHistory() {
        return actionHistory;
    }

    /**
     * @return the actionWasSuccess
     */
    public boolean isActionWasSuccess() {
        return actionWasSuccess;
    }

    /**
     * constructor for the OrderSimulatorFeController.
     * The constructor instanciates the osgAppManager
     */
    public OrderSimulatorFeController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  OrderSimulatorFeController");
        }
        if (osgAppManager == null) {
            LOG.error("osgAppManager from ServiceLocater was null");
            throw new IllegalStateException("Could not configure osgAppManager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("osgAppManager = " + osgAppManager);
        }
        globalParameters = osgAppManager.loadOrderGeneratorParameters();
    }

    /**
     * Via the globalParameters all parameters are set and read by the frontend except for the customerTypeParameters.
     * @return the globalParameters
     */
    public GlobalParameters getGlobalParameters() {
        return globalParameters;
    }

    /**
     * Returns a collection of nested {@link CustomerTypeParameters} from the current loaded
     * {@link GlobalParameters}. Workaround method to be able to represent {@link java.util.Map} of 
     * {@link CustomerTypeParameters} in the ice:dataTable in the view.
     * 
     * @return collection of currently loaded {@link CustomerTypeParameters}
     */
    public Collection<CustomerTypeParameters> getCustomerTypeParameters() {
        return globalParameters.getTypeSpecificParameters().values();
    }

    /**
     * Is called when the user presses the start-generator button.
     * @param event ignored
     */
    public void saveGlobalParameters(ActionEvent event) {
        try {
            osgAppManager.saveOrderGeneratorParameters(globalParameters);
        } catch (ApplicationException e) {
            // TODO (MH) Read error code and trigger FE error handling
        }
    }

    /**
     * @return whether the order generator is running
     */
    public boolean isOrderGeneratorRunning() {
        return osgAppManager.isOrderGeneratorRunning();
    }

}
