/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.jsf.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

import com.icesoft.faces.component.DisplayEvent;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.OrderReportingManager;
import de.itemis.qimpress.showcase.order_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.order_simulator.be.manager.reports.SalesPerCustomerSummary;

/**
 * Request-scoped controller for handling order reports generation requests. 
 * Processes report query parameters and requests for a corresponding report 
 * in the backend, making it available for the view rendering. The reports
 * data is stored in the scope of the controller, until the user places
 * another report generation request.
 * 
 * @author Wladimir Safonov
 *
 */
public class OrderReportingController implements Serializable {

    private static final long serialVersionUID = 8694939161563782696L;

    private static final Logger LOG = Logger.getLogger(OrderReportingController.class);

    private Date orderReportFrom;
    private Date orderReportTill;
    private String orderReportCustomerCategory;
    private String orderReportCustomerType;
    
    private List<SalesPerCustomerSummary> salesPerCustomerListReport;
    private List<Order> customerOrders;
    private String selectedCustomerName;
    private boolean ordersPopupVisible;
    
    private String lastOrderNumber;
    
    private OrderReportingManager orderReportingManager = ServiceLocator.getInstance().getOrderReportingManager();
    
    
    public OrderReportingController() {
        if (orderReportingManager == null) {
            LOG.error("OrderReportingManager from ServiceLocater was null");
            throw new IllegalStateException("Could not locate OrderReportingManager");
        }
    }
    
    /**
     * @return the orderReportFrom
     */
    public Date getOrderReportFrom() {
        return orderReportFrom;
    }

    /**
     * @param orderReportFrom the orderReportFrom to set
     */
    public void setOrderReportFrom(Date orderReportFrom) {
        this.orderReportFrom = orderReportFrom;
    }

    /**
     * @return the orderReportTill
     */
    public Date getOrderReportTill() {
        return orderReportTill;
    }

    /**
     * @param orderReportTill the orderReportTill to set
     */
    public void setOrderReportTill(Date orderReportTill) {
        this.orderReportTill = orderReportTill;
    }

    /**
     * @return the orderReportCustomerCategory
     */
    public String getOrderReportCustomerCategory() {
        return orderReportCustomerCategory;
    }

    /**
     * @param orderReportCustomerCategory the orderReportCustomerCategory to set
     */
    public void setOrderReportCustomerCategory(String orderReportCustomerCategory) {
        this.orderReportCustomerCategory = orderReportCustomerCategory;
    }

    /**
     * @return the orderReportCustomerType
     */
    public String getOrderReportCustomerType() {
        return orderReportCustomerType;
    }

    /**
     * @param orderReportCustomerType the orderReportCustomerType to set
     */
    public void setOrderReportCustomerType(String orderReportCustomerType) {
        this.orderReportCustomerType = orderReportCustomerType;
    }

    /**
     * @return the lastOrderNumber
     */
    public String getLastOrderNumber() {
        return lastOrderNumber;
    }

    /**
     * @param lastOrderNumber the lastOrderNumber to set
     */
    public void setLastOrderNumber(String lastOrderNumber) {
        this.lastOrderNumber = lastOrderNumber;
    }

    /**
     * @return the salesPerCustomerListReport
     */
    public List<SalesPerCustomerSummary> getSalesPerCustomerListReport() {
        return salesPerCustomerListReport;
    }

    /**
     * @return the customerOrders
     */
    public List<Order> getCustomerOrders() {
        return customerOrders;
    }

    /**
     * @return the selectedCustomerName
     */
    public String getSelectedCustomerName() {
        return selectedCustomerName;
    }

    /**
     * @return the ordersPopupVisible
     */
    public boolean isOrdersPopupVisible() {
        return ordersPopupVisible;
    }

    /**
     * Is called when the user presses the start-generator button.
     * @param event ignored
     */
    public void createSalesPerCustomerReport(ActionEvent event) {
        salesPerCustomerListReport = orderReportingManager.calculateSalesPerCustomer(
                orderReportFrom, orderReportTill, orderReportCustomerCategory, orderReportCustomerType);
    }
    
    /**
     * Toggles visibility state of the Customer Orders pop-up.
     * 
     */
    public void toggleOrdersPopup() {
        ordersPopupVisible = !ordersPopupVisible;
    }
    
    /**
     * Action listener for the browse orders command link.
     * Loads all orders for the respective customer and selected dates
     * and shows them in the Customer Orders pop-up.
     * 
     * @param event <code>ActionEvent</code> for this listener
     */
    public void customerOrdersDisplayListener(ActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> customerOrdersDisplayListener()");
        }
        
        selectedCustomerName = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap()
                .get("customerName");
        String customerNumber = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap()
                .get("customerNumber");
        try {
            customerOrders = orderReportingManager.getOrdersForCustomerAndInterval(
                    customerNumber, orderReportFrom, orderReportTill);
        } catch (ApplicationException e) {
            // TODO (MH) Read error code and trigger FE error handling
        }
        toggleOrdersPopup();
    }
    
    /**
     * Action listener for the close button of the Customer Orders pop-up.
     * 
     * @param event <code>ActionEvent</code> for this listener
     */
    public void closeOrdersPopupListener(ActionEvent event) {
        toggleOrdersPopup();
    }
    
}
