/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.manager;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager;
import de.itemis.qimpress.showcase.order_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.order_simulator.be.manager.model.TimeParameters;

/**
 * JUnit test class for
 * {@link de.itemis.qimpress.showcase.order_simulator.be.manager.OrderSimulatorManager}.
 * 
 * @author Wladimir Safonov
 *
 */
public class OrderSimulatorManagerTest {

    private static final Logger LOG = Logger.getLogger(OrderSimulatorManagerTest.class);
    
    private static OrderSimulatorManager ORDER_SIMULATOR_MANAGER = ServiceLocator.getInstance().getOrderSimulatorManager();
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called initTestSuite()");
        }
        
        
        assertNotNull("Failed to locate OrderSimulatorManager instance over ServiceLocator: result is null", ORDER_SIMULATOR_MANAGER);
    }
    
    @Test
    public void testLoadGlobalParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called testLoadGlobalParameters()");
        }
        
        GlobalParameters globalParameters = ORDER_SIMULATOR_MANAGER.loadOrderGeneratorParameters();
        assertNotNull("Failed to load GlobalParameters: result is null", globalParameters);
        assertNotNull("Failed to load GlobalParameters: CustomerTypeParameters is null", 
                globalParameters.getTypeSpecificParameters());
        assertTrue("Failed to load GlobalParameters: CustomerTypeParameters is empty", 
                globalParameters.getTypeSpecificParameters().size() > 0);
    }
    
    @Test
    public void testOrderGeneratorJob() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called testOrderGeneratorJob()");
        }
        
        try {
            TimeParameters timeParameters = new TimeParameters();
            ORDER_SIMULATOR_MANAGER.startOrderGenerator(timeParameters);
            Thread.sleep(3000);
            ORDER_SIMULATOR_MANAGER.stopOrderGenerator();
            Thread.sleep(3000);
            ORDER_SIMULATOR_MANAGER.startOrderGenerator(timeParameters);
            Thread.sleep(3000);
            ORDER_SIMULATOR_MANAGER.stopOrderGenerator();
        } catch (Exception e) {
            e.printStackTrace();
            fail("Failed to start/stop generator");
        }
    }
}
