/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.order_simulator.tests.be.manager;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;

import de.itemis.qimpress.showcase.order_simulator.be.domain.Order;
import de.itemis.qimpress.showcase.order_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.order_simulator.be.manager.OrderReportingManager;
import de.itemis.qimpress.showcase.order_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.order_simulator.be.manager.reports.SalesPerCustomerSummary;

/**
 * @author Wladimir Safonov
 *
 */
public class OrderReportingManagerTest {

    private static final Logger LOG = Logger.getLogger(OrderReportingManagerTest.class);

    private static OrderReportingManager ORDER_REPORTING_MANAGER = ServiceLocator.getInstance()
            .getOrderReportingManager();

    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        assertNotNull("Failed to locate OrderReportingManager instance over ServiceLocator: result is null",
                ORDER_REPORTING_MANAGER);
    }

    //    @Test
    public void testCalculateSalesPerCustomer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testCalculateSalesPerCustomer()");
        }

        Date from, till;
        Calendar calend = Calendar.getInstance();
        calend.clear();
        calend.set(2009, 0, 27);
        from = calend.getTime();
        till = calend.getTime();

        List<SalesPerCustomerSummary> salesPerCustomer = ORDER_REPORTING_MANAGER.calculateSalesPerCustomer(from, till,
                "", null);

        assertNotNull("calculateSalesPerCustomer returned null", salesPerCustomer);
        assertTrue("SalesPerCustomerSummary list is empty", salesPerCustomer.size() > 0);
        assertTrue("SalesPerCustomerSummary list has unexpected size", salesPerCustomer.size() == 8);

        SalesPerCustomerSummary firstSalesPerCustomer = salesPerCustomer.get(0);
        assertEquals("SalesPerCustomerSummary has unexpected sales volume", firstSalesPerCustomer.getSalesVolume(),
                new BigDecimal("1428.18"));
    }

    //    @Test
    public void testGetOrderByCustomerAndInterval() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testCalculateSalesPerCustomer()");
        }

        Date from, till;
        Calendar calend = Calendar.getInstance();
        calend.clear();
        calend.set(2009, 1, 16);
        from = calend.getTime();
        till = calend.getTime();

        List<Order> ordersList = null;
        try {
            ordersList = ORDER_REPORTING_MANAGER.getOrdersForCustomerAndInterval("000200900", from, till);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail();
        }

        assertNotNull("getOrdersForCustomeAndInterval returned null", ordersList);
        assertTrue("Orders list is empty", ordersList.size() > 0);
        assertTrue("Orders list has unexpected size", ordersList.size() == 25);
    }
}
